/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import java.util.logging.Level;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.List;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 *
 * @author kshitiz
 */
public class StickyRoundRobinRouter extends RoundRobinRouter {
    
    private static final LogUtil _logger = new LogUtil(StickyRoundRobinRouter.class);

    /** Creates a new instance of StickyRoundRobinRouter */
    public StickyRoundRobinRouter(List<ServerCluster> clusters,
        boolean activeRouting) {
        super(clusters, activeRouting);
    }

    public ServerInstance selectInstance(HttpRequest req) {
        String beRoute = StickyBERouteKeyExtractor.getBERouteKey(req);
        ServerInstance instance = null;

        if (beRoute != null) {
            _logger.logMsg(Level.INFO, "Found " + CLBConstants.BEROUTE_KEY_NAME 
                    + " key in request with value : " + beRoute);
            
            //select an instance using BERoute key and assign it to instance
            instance = controller.getGlobalInstanceMap()
                                 .getServerInstance(beRoute);

            if (instance != null) {
                _logger.logMsg(Level.INFO, "Instance " + instance.getName() + " found corresponding to "
                        + CLBConstants.BEROUTE_KEY_NAME + " key : " + beRoute);
                _logger.logMsg(Level.INFO, "Instance " + instance.getName() + " health : " 
                        + instance.isHealthy());
                _logger.logMsg(Level.INFO, "Instance " + instance.getName() + " enabled : " 
                        + instance.isEnabled());
                _logger.logMsg(Level.INFO, "Instance " + instance.getName() + " quiesced : " 
                        + instance.isQuiesced());
                /* Need to select another instance from cluster in below cases
                 * 1. Instance is unhealthy
                 * 2. Instance is disabled as well as quiesced
                 */
                if (!instance.isHealthy() ||
                        (instance.isDisabled() && instance.isQuiesced())) {
                    //select another instance from cluster
                    _logger.logMsg(Level.INFO, "Looking for instance from cluster");
                    instance = instance.getServerCluster().getClusterRouter()
                                       .selectInstance(req);
                }
            }
        }

        //if no instance is found, select any active instance
        if (instance == null) {
            _logger.logMsg(Level.INFO, "Looking for an active instance");
            instance = getActiveInstance();
        }

        return instance;
    }
}
