/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import javax.servlet.sip.SipServletRequest;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.w3c.dom.Element;

import com.sun.grizzly.util.http.Cookies;
import com.sun.grizzly.util.http.ServerCookie;


public class CookieCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private String cookieName = null;

    public CookieCondition() {
    }

    public static String getCookieValue(Cookies cookies, String cookieName,
        String defaultValue) {
        if (cookies == null) {
            return defaultValue;
        }

        for (int i = 0; i < cookies.getCookieCount(); i++) {
            ServerCookie cookie = cookies.getCookie(i);

            if (cookieName.equals(cookie.getName().getString())) {
                return (cookie.getValue().getString());
            }
        }

        return (defaultValue);
    }

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public void addElmentData(Element element) {
        cookieName = element.getAttribute("name");

        String returnCondition = element.getAttribute("return");

        if (returnCondition != null) {
            setReturnCondition(returnCondition);
        }
    }

    @Override
    public String evaluate(Object request) {
        int conditionType = getConditionType();

        String cookieVal = null;

        if (cookieName == null) {
            return null;
        }

        if (request instanceof SipServletRequest) {
            return null; // only applicable for SIP
        } else if (request instanceof HttpRequest) {
            cookieVal = getCookieValue(((HttpRequest) request).getCookies(),
                    cookieName, null);

            switch (conditionType) {
            case TYPE_DEFINED:

                if (cookieVal != null) {
                    return processReturnLogic(request, getReturnCondition());
                } else {
                    return null;
                }

            case TYPE_UNDEFINED:

                if (cookieVal == null) {
                    return processReturnLogic(request, getReturnCondition());
                } else {
                    return null;
                }
            }
        }

        return null;
    }
}
