/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import org.jvnet.glassfish.comms.util.LogUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;

import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;


public class DomUtil {
    private static LogUtil logger = new LogUtil(LogUtil.CLB_LOG_DOMAIN);

    /**
     * Returns a textual representation of a DOM object into a text string..
     *
     * @param document DOM object to parse.
     * @return String representation of <i>document</i>.
     */
    static public String documentToString(Document document) {
        String result = null;

        if (document != null) {
            StringWriter strWtr = new StringWriter();
            StreamResult strResult = new StreamResult(strWtr);
            TransformerFactory tfac = TransformerFactory.newInstance();

            try {
                Transformer t = tfac.newTransformer();
                t.setOutputProperty(OutputKeys.ENCODING, "iso-8859-1");
                t.setOutputProperty(OutputKeys.INDENT, "yes");
                t.setOutputProperty(OutputKeys.METHOD, "xml"); // xml, html,
                                                               // text

                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount",
                    "4");
                t.transform(new DOMSource(document.getDocumentElement()),
                    strResult);
            } catch (Exception e) {
                logger.warning("XML.toString(Document): " + e);
            }

            result = strResult.getWriter().toString();
        }

        return result;
    } // toString()

    /**
     * Returns the first child element that matches the
     *
     * @param xpathExpression
     * @param referenceNode
     * @return
     */
    public static Element getChildElement(String xpathExpression,
        Node referenceNode) throws IllegalArgumentException {
        Element returnMe = null;
        ArrayList<Element> elementArray = getChildElements(xpathExpression,
                referenceNode);

        if (elementArray.size() != 0) {
            returnMe = elementArray.get(0);
        }

        return returnMe;
    }

    /**
     * retreives all child Nodes of tyoe Element as an ArrayList
     *
     * @param xpathExpression
     * @param referenceNode
     * @return Arraylist of child elements
     */
    public static ArrayList<Element> getChildElements(Node referenceNode)
        throws IllegalArgumentException {
        ArrayList<Element> elementList = new ArrayList<Element>();

        try {
            NodeList nodeList = referenceNode.getChildNodes();
            int noNodes = nodeList.getLength();

            for (int i = 0; i < noNodes; i++) {
                if (nodeList.item(i) instanceof Element) {
                    elementList.add((Element) nodeList.item(i));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }

        return elementList;
    }

    /**
     * retreives all child Nodes of tyoe Element as an ArrayList
     *
     * @param xpathExpression
     * @param referenceNode
     * @return Arraylist of child elements
     */
    public static ArrayList<Element> getChildElements(String xpathExpression,
        Node referenceNode) throws IllegalArgumentException {
        ArrayList<Element> elementList = new ArrayList<Element>();

        try {
            XPath xpath = XPathFactory.newInstance().newXPath();

            NodeList nodeList = (NodeList) xpath.evaluate(xpathExpression,
                    referenceNode, XPathConstants.NODESET);

            int noNodes = nodeList.getLength();

            for (int i = 0; i < noNodes; i++) {
                if (nodeList.item(i) instanceof Element) {
                    elementList.add((Element) nodeList.item(i));
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }

        return elementList;
    }

    /**
     * Returns the first child element that matches the
     *
     * @param xpathExpression
     * @param referenceNode
     * @return
     */
    public static String getElementChildTextNode(String xpathExpression,
        Node referenceNode) throws IllegalArgumentException {
        String textNode = null;
        Element elementNode = getChildElement(xpathExpression, referenceNode);

        if (elementNode != null) {
            textNode = ((Text) elementNode.getFirstChild()).getData().trim();
        }

        return textNode;
    }

    /**
     * Output the DOM tree to the specified stream as an XML document. See the
     * XMLDocumentWriter example for the details.
     */
    public static void output(Node node, OutputStream out)
        throws TransformerConfigurationException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();

        transformer.transform(new javax.xml.transform.dom.DOMSource(node),
            new javax.xml.transform.stream.StreamResult(out));
    }

    /**
     *
     * @param iStream
     */
    public static org.w3c.dom.Document parseXmlDocument(InputStream iStream) {
        org.w3c.dom.Document doc = null;

        try {
            // Get a JAXP parser factory object
            javax.xml.parsers.DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

            // Tell the factory what kind of parser we want
            dbf.setValidating(false);

            // Use the factory to get a JAXP parser object
            javax.xml.parsers.DocumentBuilder parser = dbf.newDocumentBuilder();

            // Tell the parser how to handle errors. Note that in the JAXP API,
            // DOM parsers rely on the SAX API for error handling
            parser.setErrorHandler(new org.xml.sax.ErrorHandler() {
                    public void error(SAXParseException e) {
                        logger.warning(e.getMessage());
                    }

                    public void fatalError(SAXParseException e)
                        throws SAXException {
                        logger.severe(e.getMessage());
                        throw e;
                    }

                    public void warning(SAXParseException e) {
                        logger.warning(e.getMessage());
                    }
                });

            // Finally, use the JAXP parser to parse the InputStream. This call
            // returns
            // a Document object. Now that we have this object, the rest of this
            // class uses the DOM API to work with it; JAXP is no longer
            // required.
            doc = parser.parse(iStream);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return doc;
    }
}
