/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.util;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import java.io.IOException;

import java.net.InetAddress;

import com.ericsson.ssa.sip.SipURIDecoder;
import com.ericsson.ssa.sip.SipURIEncoder;


/**
 * Misc. utility methods.
 */
public class LoadbalancerUtil {
    private static final boolean DO_BASE64 = true;
    private static BASE64Decoder decoder;
    private static BASE64Encoder encoder;
    private static SipURIDecoder sipURIDecoder;
    private static SipURIEncoder sipURIEncoder;

    private LoadbalancerUtil() {
    } // Disable creation

    /**
     * Encodes the specific string to a string that only contains valid
     * characters for a SIP parameter.
     *
     * @param raparamm the parameter to encode
     * @return the encoded parameter
     */
    public static String encodeParameter(String str) {
        return encodeParameter(str.getBytes());
    }

    /**
     * Decodes a parameter that have been encoded using
     * {@link #encodeParameter(String)}.
     *
     * @param encodedParam the encoded parameter
     * @return the decoded parameter
     * @throws IOException thrown in case decoding fails
     */
    public static String decodeParameter(String encodedParam)
        throws IOException {
        if (decoder == null) {
            decoder = new BASE64Decoder();
            sipURIDecoder = new SipURIDecoder();
        }
        
	String uriDecoded = sipURIDecoder.decode(encodedParam);
	if (DO_BASE64) {
	    return new String(decoder.decodeBuffer(uriDecoded));
	} else {
	    return uriDecoded;
	}
    }

    /**
     * Encodes the specific byte array to a string that only contains valid
     * characters for a SIP parameter.
     *
     * @param bytes the bytes to encode
     * @return the encoded string
     */
    public static String encodeParameter(byte[] bytes) {
        if (encoder == null) {
            encoder = new BASE64Encoder();
            sipURIEncoder = new SipURIEncoder();
        }
        
        String str;
        if (DO_BASE64) {
            str = encoder.encode(bytes);
        } else {
            str = new String(bytes);
        }
	return sipURIEncoder.encodeParameter(str);
    }

    /**
     * Decodes a parameter that have been encoded using
     * {@link #encodeParameter(String)}.
     *
     * @param encodedParam the encoded parameter
     * @return the decoded parameter
     * @throws IOException thrown in case decoding fails
     */
    public static byte[] decodeParameterToBytes(String encodedParam)
        throws IOException {
        if (decoder == null) {
            decoder = new BASE64Decoder();
            sipURIDecoder = new SipURIDecoder();
        }

        String uriDecoded = sipURIDecoder.decode(encodedParam);
        if (DO_BASE64) {
            return decoder.decodeBuffer(uriDecoded);
        } else {
            return uriDecoded.getBytes();
        }
    }

    /**
     * Gets the numeric IP address of the specified InetAddress.
     * @param inetAddress the address
     * @return the numeric IP address of the specified InetAddress.
     */
    public static String getNumericIpAddress(InetAddress inetAddress) {
        byte[] addressBytes = inetAddress.getAddress();

        return unsigned(addressBytes[0]) + "." + unsigned(addressBytes[1]) +
        "." + unsigned(addressBytes[2]) + "." + unsigned(addressBytes[3]);
    }

    private static int unsigned(byte b) {
        if (b >= 0) {
            return b;
        }

        int i = b;

        return i & 0xff;
    }
}
