/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy;

import com.sun.grizzly.Controller.Protocol;

import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.api.Protocols;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;


/**
 * This is an implementation of an Endpoint which holds the host, port
 * and protocol details of an instance. This is similar to the TargetTuple
 * implementation in SIP stack.
 *
 * @author rampsarathy
 */
public class DefaultEndpoint implements Endpoint {
    /**
     * Host name.
     */
    protected String host = null;

    /**
     * Port number.
     */
    protected int port = 0;

    /**
     * Socket address corresponding to this host.
     */
    protected SocketAddress socket = null;

    /**
     * Denotes if the endpoint is local
     */
    protected boolean local = false;

    /**
     * Is this a TLS endpoint.
     */
    protected boolean secure = false;

    /** Creates a new instance of DefaultEndpoint */
    public DefaultEndpoint() {
        this("localhost", 8080);
    }

    public DefaultEndpoint(String host, int port) {
        this.host = host;
        this.port = port;
        this.socket = null;
    }

    public DefaultEndpoint(SocketAddress address) {
        this.socket = address;
    }

    public SocketAddress getSocketAddress() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }

        return this.socket;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public InetAddress getIp() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }

        return ((InetSocketAddress) (this.socket)).getAddress();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        if (this.socket == null) {
            this.socket = new InetSocketAddress(this.host, this.port);
        }

        return ((InetSocketAddress) (this.socket)).getPort();
    }

    /**
     *
     *
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Endpoint)) {
            return false;
        }

        Endpoint ep = (Endpoint) obj;

        if (port != ep.getPort()) {
            return false;
        }

        if ((this.getIp() != null) && !this.getIp().equals(ep.getIp())) {
            return false;
        }

        if (this.isSecure() != ep.isSecure()) {
            return false;
        }

        return true;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isLocal() {
        return this.local;
    }

    /**
     *
     *
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return this.getIp().hashCode() ^ this.port;
    }

    public String key() {
        String key = null;

        if (this.isSecure()) {
            key = "tls:" + this.getIp() + ":" + this.getPort();
        } else {
            key = "tcp:" + this.getIp() + ":" + this.getPort();
        }

        return key;
    }

    public String toString() {
        return this.key();
    }
}
