/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.config;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ApplicationServer;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author
 */
public class ProxyConfig {
    private static final String LOCALHOST = "localhost";
    private static final int PORT = 1111;
    private static final String PACKAGE_NAME = "clb";
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    public static final String DEFAULT_INSTANCES_LIST = "localhost:1111,localhost:1112,localhost:1113";

    /** Creates a new instance of ProxyConfig */
    private static String addressList = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.instances");
    private static String port = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.localport");
    private static String loglevel = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.loglevel");
    private static String host = System.getProperty(
            "org.jvnet.glassfish.comms.clb.proxy.localhost");

    /**
     * domain.xml
     */
    public static int HTTP_PAYLOAD_POOL_SIZE = 100;
    public static int HTTPS_PAYLOAD_POOL_SIZE = 100;
    public static final int DEFAULT_INPUTBB_SIZE = 5 * 4096;
    public static int MAX_SEND_RETRY = 3;
    private static Logger _logger = Logger.getLogger(PACKAGE_NAME);
    private static ProxyConfig _thisInstance = null;
    public static int MAX_RETRY_COUNTS = 2;
    public final static String SAILFIN_PROXY_PROTOCOL_FINDER = "org.jvnet.glassfish.comms.clb.proxy.protocolfinder";
    public final static String SAILFIN_PROXY_PROTOCOL_HANDLER = "org.jvnet.glassfish.comms.clb.proxy.protocolhandler";
    public final static String DEFAULT_SAILFIN_PROXY_PROTOCOL_FINDER = "org.jvnet.glassfish.comms.clb.proxy.http.LoadBalancerProxyFinder";
    public final static String DEFAULT_SAILFIN_PROXY_PROTOCOL_HANDLER = "org.jvnet.glassfish.comms.clb.proxy.http.LoadBalancerProxyHandler";
    public static final String PIPELINE_CLASS_PROPERTY = "com.sun.enterprise.web.connector.grizzly.pipelineClass";
    public static final String PIPELINE_CLASS = "org.jvnet.glassfish.comms.clb.proxy.portunif.SailfinClbProxyPipeline";
    private int localport = PORT;
    private String localhost = null;
    private InetSocketAddress[] addresses;

    public ProxyConfig() {
        try {
            setAddresses();
            setLocalHost();
            setLocalPort();
            setLoglevel();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Singleton method to get this instance.
     */
    public static synchronized ProxyConfig getInstance() {
        if (_thisInstance == null) {
            _thisInstance = new ProxyConfig();
        }

        return _thisInstance;
    }

    /**
     * Singleton object, so ensure nobody clones this.
     */
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();

        // you should not be able to clone a singleton
    }

    public Logger getLogger() {
        return _logger;
    }

    private void setLoglevel() {
        Level level = Level.parse(DEFAULT_LOG_LEVEL);
        _logger.log(Level.INFO, "Setting log level");

        try {
            level = Level.parse(loglevel);
            _logger.setLevel(level);
            _logger.log(Level.INFO, "Set log level to " + _logger.getLevel());
        } catch (Exception e) {
            _logger.log(Level.SEVERE,
                "Unable to parse log level string, " + "  setting to INFO");
        }
    }

    private void setLocalHost() {
        localhost = "localhost";

        try {
            localhost = InetAddress.getLocalHost().toString();
        } catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
    }

    public String getLocalHost() {
        return localhost;
    }

    public InetSocketAddress[] getAddresses() {
        return addresses;
    }

    public void setAddresses() {
        String list = (addressList == null) ? DEFAULT_INSTANCES_LIST.toString()
                                            : addressList;
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        addresses = new InetSocketAddress[tokenizer.countTokens()];

        int counter = 0;

        while (tokenizer.hasMoreTokens()) {
            String add = tokenizer.nextToken();
            int colonindex = add.indexOf(":");
            String hostname = add.substring(0, colonindex);
            int iport = 38080;

            if (colonindex != -1) {
                String port = add.substring(colonindex + 1);

                try {
                    iport = Integer.parseInt(port);
                } catch (Exception e) {
                    _logger.log(Level.INFO,
                        "Port is not a valid port, defaulting to 38080");
                    iport = 38080;
                }
            }

            InetSocketAddress inet = new InetSocketAddress(hostname, iport);
            addresses[counter++] = inet;
        }
    }

    /*

    public void setAddressList(String list) {
        this.addressList = list;
    }

    public String getAddressList() {
        return this.addressList;
    }
     */
    private void setLocalPort() {
        // have to move this parsing some other place
        localport = PORT;

        try {
            localport = Integer.parseInt(port);
        } catch (Exception e) {
            ;
        }
    }

    public int getLocalPort() {
        return localport;
    }

    public static String getAdminPort() {
        String sn = ApplicationServer.getServerContext().getInstanceName();
        ConfigContext cc = ApplicationServer.getServerContext()
                                            .getConfigContext();
        HttpListener admin = null;

        try {
            admin = ServerHelper.getHttpListener(cc, sn,
                    ServerHelper.ADMIN_HTTP_LISTNER_ID);
        } catch (ConfigException ex) {
            ex.printStackTrace();
        }

        String port = null;

        if (admin != null) {
            port = admin.getPort();
        }

        return port;
    }

    public static String getAdminInet() {
        String sn = ApplicationServer.getServerContext().getInstanceName();
        ConfigContext cc = ApplicationServer.getServerContext()
                                            .getConfigContext();
        HttpListener admin = null;

        try {
            admin = ServerHelper.getHttpListener(cc, sn,
                    ServerHelper.ADMIN_HTTP_LISTNER_ID);
        } catch (ConfigException ex) {
            ex.printStackTrace();
        }

        String address = null;

        if (admin != null) {
            address = admin.getAddress();
        }

        return address;
    }
}
