/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.clb.proxy.config;

import java.io.InputStream;

import java.net.InetSocketAddress;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author
 */
public class RoundRobinPolicy {
    private static int count = 0;
    private static String[] hostNames = { "localhost", "localhost", "localhost" };
    private static int[] hostPorts = { 1111, 1112, 1113 };
    private static InetSocketAddress[] addresses;
    private static Logger _logger = null;

    /**
     * Creates a new instance of RoundRobinPolicy
     */
    public RoundRobinPolicy() {
    }

    public static synchronized InetSocketAddress getInetSocketAddress(
        Object header) {
        _logger = ProxyConfig.getInstance().getLogger();
        addresses = ProxyConfig.getInstance().getAddresses();
        count = (count + 1) % addresses.length;
        _logger.log(Level.FINE, "RoundRobin Policy Invoked : count : " + count);
        _logger.log(Level.INFO,
            "RoundRobin Policy Invoked : address  : " + addresses[count]);

        // if(addresses[count] == null)
        //    addresses[count] = new InetSocketAddress(hostNames[count], hostPorts[count]);
        return addresses[count];
    }
}
