/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.http;

import com.sun.enterprise.web.portunif.*;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;

import org.jvnet.glassfish.comms.clb.proxy.ProxyTask;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.util.ObjectManager;
import org.jvnet.glassfish.comms.clb.proxy.portunif.SailfinClbProxyProtocolInfo;

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * A <code>ProtocolFinder</code> implementation that parse the available
 * SocketChannel bytes looking for the 'http' bytes.
 *
 * @author
 */
public class LoadBalancerProxyFinder extends HttpProtocolFinder {
    private Logger _logger = null;
    private ObjectManager objManager;
    private TlsProtocolFinder tlsfinder;

    public LoadBalancerProxyFinder() {
        objManager = objManager.getInstance();
        objManager.initialize();
        _logger = ProxyConfig.getInstance().getLogger();
        tlsfinder = new TlsProtocolFinder();
    }

    /**
     * Try to find if the current connection is using the HTTP protocol.
     * Also if the protocol is Http, this class determines if the
     * request has to be served by the local web container or by a remote
     * instance.
     *
     * @param ProtocolInfo The ProtocolInfo that contains the information
     *                      about the current protocol.
     */
    public void find(ProtocolInfo protocolInfo) {
        _logger.log(Level.FINE, "LoadBalancerProxy Finder invoked");

        if (protocolInfo.isRequestedTransportSecure) {
            try {
                // do the handshake first
                tlsfinder.find(protocolInfo);
            } catch (IOException ex) {
                ex.printStackTrace();

                // means plain http
                //return;
            }
        }

        super.find(protocolInfo);

        if (protocolInfo.protocol != null) {
            if (protocolInfo.protocol.equals("http") ||
                    protocolInfo.protocol.equals("https")) {
                if (isRemoteTermination(protocolInfo)) {
                    protocolInfo.protocol = protocolInfo.isSecure ? "lb/https"
                                                                  : "lb/http";
                }
            }
        }

        _logger.log(Level.INFO,
            "LoadBalancerProxyFinder says " + protocolInfo.protocol);
    }

    private boolean isRemoteTermination(ProtocolInfo protocolInfo) {
        try {
            _logger.log(Level.FINE, "Inside isRemote " + protocolInfo.key);

            /*
            if ((protocolInfo.protocol != null) &&
                    (protocolInfo.protocol.equalsIgnoreCase("https"))) {
                // TODO add support for https/tls
                return false;
            }
             */

            /* We have the byte buffer, feel free to parse and get the headers
             */
            ProxyTask task = objManager.pollTask(protocolInfo.isSecure);

            task.setByteBuffer(protocolInfo.byteBuffer);
            task.setSelectionKey(protocolInfo.key);
            task.setSecure(protocolInfo.isSecure);
            task.setSSLEngine(protocolInfo.sslEngine);
            task.doTask();
            protocolInfo.inputBB = task.getBuffer();
            protocolInfo.bytesRead = task.getBuffer().position();

            Endpoint remoteHost = task.getEndpoint();

            if ((remoteHost != null) && remoteHost.isLocal()) {
                _logger.log(Level.INFO, "Local Termination request");
                task.recycle();
                objManager.offerTask(task, protocolInfo.isSecure);

                return false;
            } else {
                _logger.log(Level.INFO, "Remote Termination request");
            }

            _logger.log(Level.FINE,
                "Protocol Info bytesRead " + protocolInfo.bytesRead);
            _logger.log(Level.FINE, "Payload length " +
                task.getPayloadLength());
            ((SailfinClbProxyProtocolInfo) protocolInfo).object = task;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return true;
    }
}
