/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.util;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.http.MimeHeaders;

import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;

import java.io.IOException;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * This class is an extension of the grizzly request class.
 *
 *
 * @author James Duncan Davidson [duncan@eng.sun.com]
 * @author James Todd [gonzo@eng.sun.com]
 * @author Jason Hunter [jch@eng.sun.com]
 * @author Harish Prabandham
 * @author Alex Cruikshank [alex@epitonic.com]
 * @author Hans Bergsten [hans@gefionsoftware.com]
 * @author Costin Manolache
 * @author Remy Maucherat
 */
public class HttpRequest extends Request {
    protected Endpoint clbEndpoint = null;
    private Logger _logger = ProxyConfig.getInstance().getLogger();
    protected boolean secure = false;

    public void setConvergedLoadBalancerEndpoint(Endpoint endpoint) {
        clbEndpoint = endpoint;
    }

    public Endpoint getConvergedLoadBalancerEndpoint() {
        return clbEndpoint;
    }

    public void addHeader(String name, String value) {
        HttpInputBuffer buffer = (HttpInputBuffer) this.getInputBuffer();
        buffer.addHeader(name, value);
    }

    public void dump() {
        HttpInputBuffer buffer = (HttpInputBuffer) this.getInputBuffer();
        StringBuffer sbuf = new StringBuffer();

        for (int i = 0; i < buffer.lastValidPos(); i++) {
            sbuf.append((char) buffer.getBytes()[i]);
        }

        _logger.log(Level.INFO, sbuf.toString());
    }

    public int getHeaderLength() {
        HttpInputBuffer buffer = (HttpInputBuffer) this.getInputBuffer();

        return buffer.getHeaderLength();
    }

    public void recycle() {
        super.recycle();
        clbEndpoint = null;
        secure = false;
    }

    public void dumpHeaders() {
        _logger.log(Level.INFO, "Request URI " + this.requestURI());

        try {
            MimeHeaders headers = this.getMimeHeaders();
            Enumeration names = this.getMimeHeaders().names();

            while (names.hasMoreElements()) {
                String headername = (String) names.nextElement();
                _logger.log(Level.INFO, "Header name " + headername);
                _logger.log(Level.INFO,
                    "Header Value " + headers.getHeader(headername));
            }
        } finally {
        }
    }

    public void setSecure(boolean secured) {
        this.secure = secured;
    }

    public boolean isSecure() {
        return this.secure;
    }
}
