/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package org.jvnet.glassfish.comms.clb.proxy.http.util;

import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueueFactory;

import org.jvnet.glassfish.comms.clb.proxy.ProxyTask;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.ssl.SSLProxyTask;


/**
 * This is an object manager implementation using the ConcurrentQueue from
 * grizzly.
 *
 * @author rampsarathy
 */
public class ObjectManager {
    private static ObjectManager _thisInstance = null;
    private ConcurrentQueue<ProxyTask> tasks;
    private ConcurrentQueue<SSLProxyTask> ssltasks;

    /** Creates a new instance of ObjectManager */
    private ObjectManager() {
    }

    public static synchronized ObjectManager getInstance() {
        if (_thisInstance == null) {
            _thisInstance = new ObjectManager();
        }

        return _thisInstance;
    }

    public void initialize() {
        tasks = ConcurrentQueueFactory.makeConcurrentQueue();

        for (int i = 0; i < ProxyConfig.HTTP_PAYLOAD_POOL_SIZE; i++) {
            tasks.offer(new ProxyTask());
        }

        ssltasks = ConcurrentQueueFactory.makeConcurrentQueue();

        for (int i = 0; i < ProxyConfig.HTTPS_PAYLOAD_POOL_SIZE; i++) {
            ssltasks.offer(new SSLProxyTask());
        }
    }

    public ProxyTask pollTask(boolean secure) {
        if (secure) {
            return ssltasks.poll();
        } else {
            return tasks.poll();
        }
    }

    public void offerTask(ProxyTask task, boolean secure) {
        if (secure) {
            ssltasks.offer((SSLProxyTask) task);
        } else {
            tasks.offer(task);
        }
    }
}
