/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.outbound.ssl;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.http.algorithms.ContentLengthAlgorithm;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.WorkerThreadImpl;

import org.jvnet.glassfish.comms.clb.proxy.HttpProxy;
import org.jvnet.glassfish.comms.clb.proxy.api.Endpoint;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.outbound.ConnectionManager;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.net.ssl.SSLEngine;


/**
 *
 *
 * @author Jeanfrancois Arcand
 * @author rampsarathy
 */
public class SSLResponseCallBackHandler implements CallbackHandler<Context> {
    private ConnectorHandler connectorHandler;
    private Logger _logger = null;
    private SelectionKey clientKey;
    private ReadFilter readFilter;
    private ContentLengthAlgorithm algorithm;
    private Endpoint ep;
    private boolean keepAlive = false;
    private ConnectionManager connectionManager;
    private SSLEngine sslEngine;
    private ByteBuffer outputBB;

    /**
     * This handler requires the connectorhandler that is handing this connection
     * the client socket channel to send the response back to
     * the endpoint.
     */
    public SSLResponseCallBackHandler(Endpoint ep,
        ConnectorHandler connectorHandler, SelectionKey clientkey,
        boolean keepalive, SSLEngine engine) {
        _logger = ProxyConfig.getInstance().getLogger();
        this.connectorHandler = connectorHandler;
        this.ep = ep;
        this.clientKey = clientkey;
        this.keepAlive = keepalive;
        this.sslEngine = engine;
        // make it configurable
        this.connectionManager = HttpProxy.getInstance().getConnectionManager();
        algorithm = new ContentLengthAlgorithm();
    }

    public void setKeepAlive(boolean keepalive) {
        this.keepAlive = keepalive;
    }

    /**
     * Called when the connection has been established.
     */
    public void onConnect(IOEvent<Context> ioEvent) {
        SelectionKey key = ioEvent.attachment().getSelectionKey();
        _logger.log(Level.FINE, "OnConnect Key " + key);

        if (key != null) {
            _logger.log(Level.FINE, "OnConnect chanel " + key.channel());
        }

        /**
         * Sometimes the connect is called with a NULL key
         * BUG ??
         */
        try {
            connectorHandler.finishConnect(key);
        } catch (Exception e) {
            e.printStackTrace();

            //clean
            return;
        }

        _logger.log(Level.FINE, "Connection created with " + key);

        ioEvent.attachment().getController()
               .registerKey(key, SelectionKey.OP_READ, Controller.Protocol.TCP);
    }

    /**
     * Allocate themandatory <code>ByteBuffer</code>s. Since the ByteBuffer
     * are maintaned on the <code>WorkerThreadImpl</code> lazily, this method
     * makes sure the ByteBuffers are properly allocated and configured.
     * This has been taken from SSLReadFilter of grizzly.
     */
    protected void allocateBuffers() {
        final WorkerThreadImpl workerThread = (WorkerThreadImpl) Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        outputBB = workerThread.getOutputBB();

        int inputBBSize = ProxyConfig.DEFAULT_INPUTBB_SIZE;
        int expectedSize = sslEngine.getSession().getPacketBufferSize();

        if (inputBBSize < expectedSize) {
            inputBBSize = expectedSize;
        }

        if (outputBB == null) {
            outputBB = ByteBuffer.allocate(inputBBSize);
        }

        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(inputBBSize * 2);
        }

        expectedSize = sslEngine.getSession().getApplicationBufferSize();

        if (expectedSize > byteBuffer.capacity()) {
            ByteBuffer newBB = ByteBuffer.allocate(expectedSize);
            //byteBuffer.flip();
            //newBB.put(byteBuffer);
            byteBuffer = newBB;
        }

        workerThread.setOutputBB(outputBB);
        workerThread.setByteBuffer(byteBuffer);

        outputBB.position(0);
        outputBB.limit(0);
    }

    public void onRead(IOEvent<Context> ioEvent) {
        Context ctx = ioEvent.attachment();

        try {
            SocketChannel clientChannel = (SocketChannel) clientKey.channel();
            allocateBuffers();
            readFilter = new ReadFilter();
            readFilter.execute(ctx);

            WorkerThread workerThread = (WorkerThread) Thread.currentThread();
            ByteBuffer byteBuffer = workerThread.getByteBuffer();
            algorithm.setSocketChannel((SocketChannel) ctx.getSelectionKey()
                                                          .channel());
            algorithm.preParse(byteBuffer);

            /**
             * Improve the logic below to write as much as we have and
             * then continue parsing in the next read, we should not
             * wait for the entire message before we start writing.
             */
            if (algorithm.parse(byteBuffer)) {
                _logger.log(Level.FINE,
                    "Algorithm says finished : " +
                    "Writing data into channel " +
                    clientChannel.socket().getRemoteSocketAddress());

                if ((clientChannel != null) && (clientChannel.isConnected())) {
                    SSLOutputWriter.flushChannel(clientChannel, byteBuffer,
                        outputBB, sslEngine);
                } else {
                    _logger.log(Level.FINE,
                        "Client closed channel, " + "cannot write response");
                    throw new Exception("Socket channel closed");
                }

                // check for keep-alive and then close the channel,
                // check the connection header
                connectionManager.removeClientEndpoint(clientKey);
                connectionManager.releaseConnection(this.connectorHandler);

                //clientChannel.close();
                if (!keepAlive) {
                    connectionManager.cancelClientKey(clientKey);
                } else {
                    connectionManager.registerClientKey(clientKey);
                }

                //   ctx.getController().cancelKey(ctx.getSelectionKey());
            } else {
                SelectionKey key = ctx.getSelectionKey();

                if ((clientChannel != null) && (clientChannel.isConnected())) {
                    //OutputWriter.flushChannel(clientChannel, byteBuffer);
                    SSLOutputWriter.flushChannel(clientChannel, byteBuffer,
                        outputBB, sslEngine);
                } else {
                    _logger.log(Level.FINE,
                        "Client closed channel, " + "cannot write response");
                    throw new Exception("Socket channel closed");
                }

                _logger.log(Level.FINE,
                    "Algorithm says there is more data to write to " +
                    clientChannel.socket().getRemoteSocketAddress());
                ctx.getController().registerKey(key, SelectionKey.OP_READ);
            }

            algorithm.postParse(byteBuffer);
        } catch (Throwable e) {
            ctx.getSelectionKey().cancel();
            HttpProxy.getInstance().getConnectionManager()
                     .releaseConnection(this.connectorHandler);
            connectionManager.removeClientEndpoint(clientKey);
            e.printStackTrace();
        } finally {
            outputBB.clear();
        }
    }

    public void onWrite(IOEvent<Context> ioEvent) {
        throw new IllegalStateException("Should not be here!");
    }
}
