/*
 *  Copyright 1999-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.ssl;

import com.sun.enterprise.web.connector.grizzly.ssl.SSLByteBufferInputStream;

import com.sun.grizzly.ssl.SSLOutputBuffer;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.HttpProxy;
import org.jvnet.glassfish.comms.clb.proxy.ProxyTask;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpInputBuffer;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;


/**
 *
 * @author rampsarathy
 */
public class SSLProxyTask extends ProxyTask {
    /** Creates a new instance of SSLProxyTask */
    public SSLProxyTask() {
    }

    @Override
    public void initialize() {
        request = new HttpRequest();
        inputBuffer = new HttpInputBuffer(request);
        inputStream = new SSLByteBufferInputStream();
        inputBuffer.setInputStream(inputStream);
        request.setInputBuffer(inputBuffer);
        response = new Response();
        outputBuffer = new SSLOutputBuffer(response,
                LoadBalancerProxyConstants.DEFAULT_HTTP_HEADER_BUFFER_SIZE,
                false);
        response.setOutputBuffer(outputBuffer);
        request.setResponse(response);
        request.setSecure(true);
        initialized = true;
    }
}
