/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.admin;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder =  {
    "cluster", "property"}
)
@XmlRootElement(name = "loadbalancer")
public class Loadbalancer {
    @XmlAttribute(name = "http-policy")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String httpPolicy;
    @XmlAttribute(name = "sip-policy")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String sipPolicy;
    @XmlAttribute(name = "dcr-file")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    protected String dcrFile;
    protected List<Cluster> cluster;
    protected List<Property> property;

    /**
     * Gets the value of the httpPolicy property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getHttpPolicy() {
        if (httpPolicy == null) {
            return "round-robin";
        } else {
            return httpPolicy;
        }
    }

    /**
     * Sets the value of the httpPolicy property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setHttpPolicy(String value) {
        this.httpPolicy = value;
    }

    /**
     * Gets the value of the sipPolicy property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getSipPolicy() {
        if (sipPolicy == null) {
            return "From-tag,To-tag,Call-id";
        } else {
            return sipPolicy;
        }
    }

    /**
     * Sets the value of the sipPolicy property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setSipPolicy(String value) {
        this.sipPolicy = value;
    }

    /**
     * Gets the value of the dcrFile property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getDcrFile() {
        if (dcrFile == null) {
            return "";
        } else {
            return dcrFile;
        }
    }

    /**
     * Sets the value of the dcrFile property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setDcrFile(String value) {
        this.dcrFile = value;
    }

    /**
     * Gets the value of the cluster property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the cluster property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCluster().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Cluster }
     *
     *
     */
    public List<Cluster> getCluster() {
        if (cluster == null) {
            cluster = new ArrayList<Cluster>();
        }

        return this.cluster;
    }

    /**
     * Gets the value of the property property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the property property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProperty().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Property }
     *
     *
     */
    public List<Property> getProperty() {
        if (property == null) {
            property = new ArrayList<Property>();
        }

        return this.property;
    }

    //Manually added methods begin here - (not jaxb generated)
    /**
     * Method to add a new cluster into the loadbalancer cluster list
     * @param cluster - the new cluster that needs to be added to loadbalancer
     */
    public void addCluster(Cluster cluster) {
        getCluster().add(cluster);
    }

    /**
     * Method to find a cluster based on its name
     * @param clusterName - The name of the cluster to find
     * @return the reference to the Cluster if the name matches one in the cluster list else return null
     */
    public Cluster findCluster(String clusterName) {
        if (clusterName == null) {
            return null;
        }

        for (int i = 0; i < getCluster().size(); i++) {
            Cluster c = getCluster().get(i);

            if (clusterName.equals(c.getName())) {
                return c;
            }
        }

        return null;
    }
}
