/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.admin;

import com.sun.enterprise.util.SystemPropertyConstants;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.*;

import javax.xml.bind.*;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the org.jvnet.glassfish.comms.clb.admin package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 *
 */
@XmlRegistry
public class ObjectFactory {
    static final String CLB_DOCTYPE = "<!DOCTYPE loadbalancer PUBLIC \"-//Sun Microsystems Inc.//DTD Sun Java System Application Server 9.1//EN\" \"http://www.sun.com/software/appserver/dtds/sun-converged-loadbalancer_1_0.dtd\">";
    static final String CLB_XML_ENCODING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.jvnet.glassfish.comms.clb.admin
     *
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link WebModule }
     *
     */
    public WebModule createWebModule() {
        return new WebModule();
    }

    /**
     * Create an instance of {@link Instance }
     *
     */
    public Instance createInstance() {
        return new Instance();
    }

    /**
     * Create an instance of {@link Loadbalancer }
     *
     */
    public Loadbalancer createLoadbalancer() {
        return new Loadbalancer();
    }

    /**
     * Create an instance of {@link Cluster }
     *
     */
    public Cluster createCluster() {
        return new Cluster();
    }

    /**
     * Create an instance of {@link Property }
     *
     */
    public Property createProperty() {
        return new Property();
    }

    /**
      * Method to load the configration from the inputStream
      *@param in - InputStream to the lb configuration
      *@throws DOMException
     *        ParserConfigurationException
     *        IOException
     *        SAXException if error occurs during parsing or unmarshalling
     */
    public Loadbalancer load(InputStream in)
        throws JAXBException, DOMException, ParserConfigurationException,
            IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);

        DocumentBuilder db = dbf.newDocumentBuilder();
        ErrorHandler errorHandler = new ErrorHandler();
        db.setErrorHandler(errorHandler);
        db.setEntityResolver(errorHandler);

        Document doc = db.parse(in);

        JAXBContext context = JAXBContext.newInstance(
                "org.jvnet.glassfish.comms.clb.admin");
        Unmarshaller unmarshaller = context.createUnmarshaller();

        Loadbalancer lb = (Loadbalancer) unmarshaller.unmarshal(doc);

        return lb;
    }

    /**
      * Method to store the configration to the specified outputStream
      *@param os - InputStream to the lb configuration
      *@throws JAXBException and IOException if error occurs during marshalling
     */
    public void store(Loadbalancer lb, OutputStream os)
        throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance(
                "org.jvnet.glassfish.comms.clb.admin");
        Marshaller marshaller = context.createMarshaller();
        //Turn on the option to format the XML
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
        //Need to custom XML Declarations. Hence turn off the default option
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", Boolean.FALSE);

        //Write out the custom XML encoding and doctype
        os.write(CLB_XML_ENCODING.getBytes());

        final String lineSeperator = System.getProperty("line.separator");
        os.write((lineSeperator != null) ? lineSeperator.getBytes()
                                         : "\\n".getBytes());
        os.write(CLB_DOCTYPE.getBytes());

        marshaller.marshal(lb, os);
    }
}


class ErrorHandler extends DefaultHandler {
    static final String CLB_DTD_FILE = "lib" + File.separator + "dtds" +
        File.separator + "sun-converged-loadbalancer_1_0.dtd";
    org.jvnet.glassfish.comms.util.LogUtil logger = new org.jvnet.glassfish.comms.util.LogUtil(ErrorHandler.class);

    public InputSource resolveEntity(String publicId, String systemId)
        throws SAXException, IOException {
        logger.infoMsg("System id " + systemId);

        final String installDir = System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
        String customSystemId = installDir + File.separator + CLB_DTD_FILE;
        logger.infoMsg("Substituting System id to " + customSystemId);

        InputSource is = new InputSource(new FileInputStream(
                    new File(customSystemId)));

        logger.infoMsg("InputStream is null? " + Boolean.toString(is == null));

        return is;
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }
}
