/*

* The contents of this file are subject to the terms

* of the Common Development and Distribution License

* (the License).  You may not use this file except in

* compliance with the License.

*

* You can obtain a copy of the license at

* https://glassfish.dev.java.net/public/CDDLv1.0.html or

* glassfish/bootstrap/legal/CDDLv1.0.txt.

* See the License for the specific language governing

* permissions and limitations under the License.

*

* When distributing Covered Code, include this CDDL

* Header Notice in each file and include the License file

* at glassfish/bootstrap/legal/CDDLv1.0.txt.

* If applicable, add the following below the CDDL Header,

* with the fields enclosed by brackets [] replaced by

* you own identifying information:

* "Portions Copyrighted [year] [name of copyright owner]"

*

* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.

* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.

*/
package org.jvnet.glassfish.comms.util;

import java.util.logging.Level;
import java.util.logging.Logger;


/** This class sets up a logger with a given LogDomain, or if no LogDomain is given the
 * value 'javax.enterprise.system.container.sip' is used instead.
 *
 */
public final class LogUtil {
    public static final String SIP_LOG_DOMAIN = "javax.enterprise.system.container.sip";
    public static final String CLB_LOG_DOMAIN = "javax.enterprise.system.container.clb";
    private static final String LOG_STRING_PACKAGE = "org.jvnet.glassfish.comms.logger";
    private final Logger log;

    /** This constructor is added just for backwards compatibility. Use the LogUtil()
     * constructor instead; the classname is no longer used for anything inside the
     * LogUtil class.
     */
    @Deprecated
    public LogUtil(Class c) {
        this(SIP_LOG_DOMAIN);
    }

    public LogUtil() {
        this(SIP_LOG_DOMAIN);
    }

    public LogUtil(String domain) {
        String module = domain.substring(domain.lastIndexOf('.'));
        String logStrings = LOG_STRING_PACKAGE + module + ".LogStrings";
        log = Logger.getLogger(domain, logStrings);
    }

    //Optimize for inlining.
    public boolean logSevere() {
        return log.isLoggable(Level.SEVERE);
    }

    //Optimize for inlining.
    public boolean logWarning() {
        return log.isLoggable(Level.WARNING);
    }

    //Optimize for inlining.
    public boolean logInfo() {
        return log.isLoggable(Level.INFO);
    }

    //Optimize for inlining.
    public boolean logConfig() {
        return log.isLoggable(Level.CONFIG);
    }

    //Optimize for inlining.
    public boolean isLoggable(final Level lvl) {
        return log.isLoggable(lvl);
    }

    public void severe(String msgId, Object... msgArgs) {
        log(Level.SEVERE, msgId, msgArgs);
    }

    public void severe(Throwable cause, String msgId, Object... msgArgs) {
        log(Level.SEVERE, cause, msgId, msgArgs);
    }

    public void warning(String msgId, Object... msgArgs) {
        log(Level.WARNING, msgId, msgArgs);
    }

    public void warning(Throwable cause, String msgId, Object... msgArgs) {
        log(Level.WARNING, cause, msgId, msgArgs);
    }

    public void info(String msgId, Object... msgArgs) {
        log(Level.INFO, msgId, msgArgs);
    }

    public void infoMsg(String msg) {
        logMsg(Level.INFO, msg);
    }

    public void config(String msgId, Object... msgArgs) {
        log(Level.CONFIG, msgId, msgArgs);
    }

    public void configMsg(String msg) {
        logMsg(Level.CONFIG, msg);
    }

    public void config(Throwable cause, String msgId, Object... msgArgs) {
        log(Level.CONFIG, cause, msgId, msgArgs);
    }

    public void configMsg(Throwable cause, String msg) {
        logMsg(Level.CONFIG, cause, msg);
    }

    public void log(Level lvl, String msgId, Object... msgArgs) {
        log.log(lvl, msgId, msgArgs);
    }

    public void log(Level lvl, Throwable cause, String msgId, Object... msgArgs) {
        // use two log messages to log exceptions to not break the interface
        log.log(lvl, msgId, msgArgs);
        log.log(lvl, "" + cause.getMessage(), cause);
    }

    public void logMsg(Level lvl, String msg) {
        log.log(lvl, msg);
    }

    public void logMsg(Level lvl, Throwable cause, String msg) {
        log.log(lvl, msg, cause);
    }
}
