package org.jvnet.glassfish.comms.deployment.backend;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

import javax.enterprise.deploy.shared.ModuleType;

import org.jvnet.glassfish.comms.util.LogUtil;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDeployer;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.XModuleType;

public class ArArchiveDeployer //extends WebArchiveDeployer 
implements ArchiveDeployer {

	private static LogUtil theirLog = new LogUtil(LogUtil.SIP_LOG_DOMAIN);
	private static final String LOGPREFIX = 
		"org.jvnet.glassfish.comms.deployment.backend.ArArchiveDeployer.";

	private ModuleType moduleType = 
        XModuleType.getModuleType(this.getClass().getName());

	public void cleanup(File moduleRootDirectory) throws Exception {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, "----- cleanup() ----");
		}
	}

	public void expand(File archivePath, File moduleRootDirectory) 
		throws Exception {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, 
				LOGPREFIX + "expanding_archive", archivePath, 
				moduleRootDirectory);
		}

		// expand stuff in the File archivePath to the moduleRootDirectory, 
		// in particular the class implementing ApplicationRouterInfo
		J2EEModuleExploder.explodeJar(archivePath, moduleRootDirectory);
	}

	public DeploymentDescriptorFile getConfigurationDDFile() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(
				Level.FINEST, "----- getConfigurationDDFile(): null ----");
		}
		return null;
	}

	public Descriptor getDefaultBundleDescriptor() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(
				Level.FINEST, "----- getDefaultBundleDescriptor(): null ----");
		}
		return null;
	}

	public Descriptor getDescriptor() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, "----- getDescriptor(): null ----");
		}
		return null;
	}

	public String getModuleDescription() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, "----- getModuleDescription(): null ----");
		}
		return null;
	}

	public ModuleType getModuleType() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(Level.FINEST, 
				LOGPREFIX + "moduletype_retrieved",
				moduleType, 
				moduleType.getModuleExtension(),
				moduleType.getValue());
		}
		return moduleType;
	}

	public DeploymentDescriptorFile getStandardDDFile() {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(
				Level.FINEST, "----- getStandardDDFile(): null ----");
		}
		return null;
	}

	public boolean handles(AbstractArchive archiveFile) {
		if (theirLog.isLoggable(Level.FINEST)){
			theirLog.log(
				Level.FINEST, LOGPREFIX + "handling_archive", archiveFile);
		}
		// will handle if the archiveFile contains some 
		// class files implementing the ApplicationRouter interface
		
		// for now we fake it by adding a isAR.txt
		// TODO investigate how to scan through archive.
		try {
            if(archiveFile.getEntry("ISAR.txt") != null ){
            	if (theirLog.isLoggable(Level.FINEST)){
            		theirLog.log(Level.FINEST, LOGPREFIX + "archive_handled");
        		}
        		return true;
            } else {
            	if (theirLog.isLoggable(Level.FINEST)){
            		theirLog.log(Level.FINEST, LOGPREFIX + "archive_not_handled");
        		}
        		return false;
            }
        }catch(IOException ioe) {
            ioe.printStackTrace();
            theirLog.severe(ioe.toString()); 
            return false;
        }
	}

	public ArchiveDescriptor prepare(
			File moduleRootDirectory,
			File moduleScratchDirectory, 
			ClassLoader parentClassLoader, 
			boolean isStartup) throws Exception {
		if (theirLog.isLoggable(Level.FINEST)){
    		theirLog.log(Level.FINEST, "----- prepare() -----");
    		theirLog.log(Level.FINEST, "----- moduleRootDirectory: " + moduleRootDirectory);
    		theirLog.log(Level.FINEST, "----- moduleScratchDirectory: " + moduleScratchDirectory);
    		theirLog.log(Level.FINEST, "----- parentClassLoader: " + parentClassLoader);
    		theirLog.log(Level.FINEST, "----- isStartup: " + isStartup);
		}
		
		// at this point, expand has already been called, 
		// so now prepare an ArchiveDescriptor
		ArArchiveDescriptor descriptor = new ArArchiveDescriptor();
		URL moduleURL = moduleRootDirectory.toURL();
		URLClassLoader loader = 
			new URLClassLoader(new URL[]{moduleURL}, parentClassLoader);
		descriptor.setModuleClassLoader(loader);
		
		return descriptor; 
	}

	public void setDescriptor(Descriptor descriptor) {
		if (theirLog.isLoggable(Level.FINEST)){
    		theirLog.log(Level.FINEST, "----- setDescriptor() -----");
		};		
	}
}