/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SipBundleDescriptor.java
 *
 * This class represents the BundleDescriptor for pure SIP and Converged
 * HTTP and SIP applications.
 * Created on February 27, 2007, 3:17 PM
 *
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.ericsson.ssa.dd.ConvergedDescriptor;
import com.ericsson.ssa.dd.SipApplication;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.pluggable.ArchiveDescriptor;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.loader.EJBClassLoader;

import org.jvnet.glassfish.comms.deployment.runtime.sip.SunSipApp;

import javax.enterprise.deploy.shared.ModuleType;


/**
 *
 * @author  Prasad Subramanian
 */
public class SipBundleDescriptor extends WebBundleDescriptor
    implements ArchiveDescriptor, ConvergedDescriptor {
    private SipApplication sipApplication = null;
    private boolean isConverged = false;
    private SunSipApp sunSipApp = null;
    private ModuleType moduleType =  XModuleType.getModuleType(
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer");

    /** Creates a new instance of SipBundleDescriptor */
    public SipBundleDescriptor() {
    }

    /**
     * Returns the classloader for the module
     * @return ClassLoader
     */
    public ClassLoader getModuleClassLoader() {
        return new EJBClassLoader();
    }

    /**
     * Sets the SipApplication object. This method is useful when we want to
     * add a SipApplication after processing the sip.xml
     * @param sipApplication the SipApplication object that holds the meta data
     *                       from the processed sip.xml
     */
    public void setSipApplication(SipApplication sipApplication) {
        this.sipApplication = sipApplication;
    }

    /**
     * Returns the SipApplication object for the module
     * @return a SipApplication object that represents the sip.xml meta data
     */
    public SipApplication getSipApplication() {
        return sipApplication;
    }

    /**
     * Returns the module type for the module that the SipBundleDescriptor
     * describes/
     * @return a ModuleType object representing the module type
     */
    public ModuleType getModuleType() {
        return moduleType;
    }

    /** 
     * Allow the SipVerifier to set the moduleType to WAR
     * while it invokes WebVerifier.
     */
    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }
    
    public void setConverged(boolean isConverged) {
        this.isConverged = isConverged;
    }

    public boolean isConverged() {
        return isConverged;
    }

    public void setSunSipDescriptor(SunSipApp sunSipApp) {
        this.sunSipApp = sunSipApp;
    }

    public SunSipApp getSunSipDescriptor() {
        if (sunSipApp == null) {
            sunSipApp = new SunSipApp();
        }

        return sunSipApp;
    }

    /**
     * Gets the session configuration information from sun-sip.xml.
     *
     * @return The session configuration information from sun-sip.xml
     */
    public SessionConfig getSunSipSessionConfig() {
        return getSunSipDescriptor().getSessionConfig();
    }
}
