/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SipRuntimeDDFile.java
 *
 * Created on Oct 10, 2007, 2:07:11 PM
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.deployment.io.runtime;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.node.RootXMLNode;

import org.jvnet.glassfish.comms.deployment.backend.SipBundleDescriptor;
import org.jvnet.glassfish.comms.deployment.runtime.sip.SipBundleRuntimeNode;


/**
 *
 * @author Prasad Subramanian
 */
public class SipRuntimeDDFile extends ConfigurationDeploymentDescriptorFile {
    private String SCAS_SIP_JAR_ENTRY = "WEB-INF/" + "sun-sip.xml";

    /**
     * @return the location of the DeploymentDescriptor file for a
     * particular type of J2EE Archive
     */
    public String getDeploymentDescriptorPath() {
        return SCAS_SIP_JAR_ENTRY;
    }

    /**
     * @return a RootXMLNode responsible for handling the deployment
     * descriptors associated with this J2EE module
     *
     * @param the descriptor for which we need the node
     */
    public RootXMLNode getRootXMLNode(Descriptor descriptor) {
        if (descriptor instanceof SipBundleDescriptor) {
            return new SipBundleRuntimeNode((SipBundleDescriptor) descriptor);
        }

        return null;
    }
}
