/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

package org.jvnet.glassfish.comms.admin.callflow;

import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.sip.Layer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.IntrospectionUtils;


/**
 *
 * @author erapdan
 */
public class CallflowAdapter implements CallflowStartup{
    
    private String REPORTER_STRING = "reporters";
    private String REPORTER_PACKAGE = "org.jvnet.glassfish.comms.admin.callflow.reporter";
    private String LOG_STRING = "log";

    private Reporter getReporter(String[] reporters){
        if(reporters.length == 1){
            return reporterForString(reporters[0]);
        }
        else {
            ComplexReporter combined = new ComplexReporter();
            for(String name: reporters) {
                Reporter r = reporterForString(name);
                combined.addReporter(reporterForString(name));
            }
            if( combined.countReporters() > 0 )
                return combined;
            return null;
        }
    }
    
    private Reporter reporterForString(String name){
        try {
            String className = REPORTER_PACKAGE + "." + name;
            Class<?> reporterClass = Class.forName(className);
            Object obj = reporterClass.newInstance();
            if( obj instanceof Reporter )
                return (Reporter)obj;            
        } catch (InstantiationException ex) {
            Logger.getLogger(CallflowAdapter.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            Logger.getLogger(CallflowAdapter.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(CallflowAdapter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
    
    public void startup() {
       final List<Layer> layers = LayerHandler.getInstance().getLayers();

        for (Layer layer : layers) {
            if (layer instanceof Traceable) {
                String reporterString = (String)IntrospectionUtils.getProperty(layer, REPORTER_STRING);
                Reporter reporter = getReporter(reporterString.split(","));
            }
        }
    }   
    
    // go through sip-stack, and set reporter for each layer depending on the parameters for the layer        

}
