/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.config;

import com.ericsson.ssa.config.Config;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.ConfigChangeEvent;
import com.sun.enterprise.admin.event.ConfigChangeEventListener;
import com.sun.enterprise.config.ConfigBean;

import org.jvnet.glassfish.comms.util.LogUtil;

import org.netbeans.modules.schema2beans.BaseBean;

import java.util.logging.Level;


public class BaseMapper implements ConfigBean2InternalMapper {
    private boolean multiple;
    private LogUtil log = new LogUtil(getClass());

    public BaseMapper() {
        this(false);
    }

    public BaseMapper(boolean isMultiple) {
        setMultiple(isMultiple);
    }

    public boolean requiresEventListerenerRegistration() {
        return false;
    }

    public String getEventType() {
        return null;
    }

    public Class getEventListenerClass() {
        return null;
    }

    public AdminEventListener getEventListenerImpl(ConfigAdapter configMapper) {
        return null;
    }

    public BaseBean[] map2Internal(ConfigBean bean, String[] ctxHolder,
        Config config) {
        String ctx = ctxHolder[0];

        if (multiple) {
            ctx = ctx + "/" + bean.getAttributeValue("id");
            ctxHolder[0] = ctx;
        }

        if (log.isLoggable(Level.FINEST)) {
            log.logMsg(Level.FINEST,
                "Mapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }

        if (log.logInfo()) {
            log.infoMsg("Mapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }
        mapAttributes2Internal(bean, ctx, config);

        return bean.childBeans(false);
    }

    public org.netbeans.modules.schema2beans.BaseBean[] remap2Internal(
        ConfigBean bean, String[] ctxHolder, Config config) {
        String ctx = ctxHolder[0];

        if (multiple) {
            ctx = ctx + "/" + bean.getAttributeValue("id");
            ctxHolder[0] = ctx;
        }

        if (log.isLoggable(Level.FINEST)) {
            log.logMsg(Level.FINEST,
                "remapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }

        if (log.logInfo()) {
            log.infoMsg("remapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }

        config.clear(ctx);
        mapAttributes2Internal(bean, ctx, config);

        return bean.childBeans(false);
    }

    public org.netbeans.modules.schema2beans.BaseBean[] unmap2Internal(
        ConfigBean bean, String[] ctxHolder, Config config) {
        String ctx = ctxHolder[0];

        if (multiple) {
            ctx = ctx + "/" + bean.getAttributeValue("id");
            ctxHolder[0] = ctx;
        }

        if (log.isLoggable(Level.FINEST)) {
            log.logMsg(Level.FINEST,
                "Unmapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }

        if (log.logInfo()) {
            log.infoMsg("Unmapping [ctx = " + ctx + ", bean = " +
                ((bean != null) ? bean.name() : "null") + "] to config");
        }

        config.remove(ctx);

        return null;
    }
    
    protected void mapAttributes2Internal(ConfigBean bean, String ctx, Config config) {
        for (String attribute : bean.getAttributeNames()) {
            String attributeValue = bean.getAttributeValue(attribute);
            mapAttribute2Internal(attribute, attributeValue, bean, ctx, config);
        }
    }    

    protected void mapAttribute2Internal(String attribute, String value,
        ConfigBean bean, String ctx, Config config) {
        if (value != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.logMsg(Level.FINEST,
                    "Adding config entry [node = " + ctx + ", key = " +
                    attribute + ", value = " + value + "]");
            }

            config.set(ctx, attribute, value);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.logMsg(Level.FINEST,
                    "Skipping config entry [node = " + ctx + ", key = " +
                    attribute + "] expected optional.");
            }
        }
    }

    public boolean getMultiple() {
        return multiple;
    }

    protected void setMultiple(boolean isMultiple) {
        multiple = isMultiple;
    }
}
