/*
 * SipListenerMapper.java
 *
 * Created on September 2, 2007, 9:55 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.jvnet.glassfish.comms.admin.config;


import com.sun.enterprise.admin.event.ElementChangeEvent;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.ConfigException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

/**
 *
 * @author elnelbo
 */
public class ConfigBean2InternalMapperImpl extends BaseMapper implements InvocationHandler {
    private ConfigAdapter configAdapter;
    private String eventType;
    private Class eventListenerClass;
    

    public ConfigBean2InternalMapperImpl(String anEventType, Class anEventListenerClass, boolean isMultiple) {
        super(isMultiple);
        eventType = anEventType;
        eventListenerClass = anEventListenerClass;
    }

    public boolean requiresEventListerenerRegistration() {
        return true;
    }

    public String getEventType() {
        return eventType;
    }

    public AdminEventListener getEventListenerImpl(ConfigAdapter aConfigAdapter) {
        configAdapter = aConfigAdapter;
        return (AdminEventListener) Proxy.newProxyInstance(eventListenerClass.getClassLoader(), new Class[]{eventListenerClass}, this);
    }

    public Class getEventListenerClass() {        
        return eventListenerClass;
    }        

    public void handleCreate(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            if (configChange instanceof ConfigAdd) {
                String xpath = ((ConfigAdd)configChange).getXPath();
                try {
                    ConfigBean bean = adminEvent.getConfigContext().exactLookup(xpath);
                    configAdapter.configureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {
                    //TODO Log and continue
                    //dynamic reconfig failed
                    ex.printStackTrace();
                }
            }
        }        
    }

    public void handleUpdate(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            String xpath = null;
            
            if (configChange instanceof ConfigAdd) {
                System.out.println("update change = Add");
                xpath = ((ConfigAdd)configChange).getXPath();
            } else if (configChange instanceof ConfigUpdate) {
                System.out.println("update change = Update");
                xpath = ((ConfigUpdate)configChange).getXPath(); 
            }
            
            if (xpath!=null) {
                try {
                    ConfigBean bean = adminEvent.getConfigContext().exactLookup(xpath);
                    configAdapter.reconfigureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {
                    //TODO Log and continue
                    //dynamic reconfig failed
                    ex.printStackTrace();
                }
            }
        }        
    }

    public void handleDelete(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            if (configChange instanceof ConfigDelete) {
                String xpath = ((ConfigDelete)configChange).getXPath();
                try {
                    ConfigBean bean = adminEvent.getOldConfigContext().exactLookup(xpath);
                    configAdapter.unconfigureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {
                    //TODO Log and continue
                    //dynamic reconfig failed
                    ex.printStackTrace();
                }
            }
        }        
    }
    
    private String xpath2Context(String xpath) {
        //Note the xpath format is information we actually should not know.
        //Needs to be abstracted properly at some point.
        // /domain/configs/config[@name='server-config']/sip-service/sip-listener[@id='EltjoWasHere']
        String[] xpathElements = xpath.split("[\\[\\]]+");
        StringBuffer context = new StringBuffer();
        String[] ctxParts = xpathElements[2].split("/");
        
        int i = 0;
        for (String ctxPart : ctxParts) {
            if (ctxPart.length()>0) {
                //A context does not include the element it self        
                if (i<(ctxParts.length-1)) {
                    context.append(ConfigBean.camelize(ctxPart));
                    context.append("/");
                }
            }
            i++;
        }
        
        System.out.println("xpath2Context: "+xpath+" -> "+context.toString());
        return context.toString();
    }    

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        System.out.println("EventListener proxy called for event type: "+eventType);
        System.out.println("Method = "+method);
        System.out.println("Args = "+Arrays.asList(args));
        Method dispatchMethod = getClass().getMethod(method.getName(), ElementChangeEvent.class);
        Object result = null;
        if (dispatchMethod!=null) {
            result = dispatchMethod.invoke(this, args[0]);
        }
        
        return result;
    }
}
