/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.monitor;

import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.OverloadProtectionManager;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.transaction.TransactionManager;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import org.jvnet.glassfish.comms.admin.monitor.registry.spi.extensions.SipMonitoringManagerImpl;
import org.jvnet.glassfish.comms.util.LogUtil;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author erapdan
 */
public class MonitoringAdapter implements MonitoringStartup {
    //    private LogUtil log = new LogUtil(MonitoringAdapter.class);
    private LogUtil log = new LogUtil();

    public MonitoringAdapter() {
    }    
    
    public void startup() {
        final List<Layer> layers = LayerHandler.getInstance().getLayers();
        SipMonitoringManagerImpl smmi = SipMonitoringManagerImpl.getInstance();

        for (Layer layer : layers) {
            if (layer instanceof SessionManager) {
                if (log.logInfo()) {
                    log.info("Initializing Session Manager Stats");
                }
                smmi.enableSipStats(SipMonitoringManagerImpl.SESSION_MANAGER, layer, MonitoringLevel.HIGH);
            } else if (layer instanceof NetworkManager) {
                if (log.logInfo()) {
                    log.info("Initializing Network Manager Stats");
                }
                smmi.enableSipStats(SipMonitoringManagerImpl.NETWORK_MANAGER, layer, MonitoringLevel.HIGH);
            } else if (layer instanceof TransactionManager) {
                if (log.logInfo()) {
                    log.info("Initializing Transaction Manager Stats");
                }
                smmi.enableSipStats(SipMonitoringManagerImpl.TRANSACTION_MANAGER, layer, MonitoringLevel.HIGH);
            } else if (layer instanceof OverloadProtectionManager) {
                if (log.logInfo()) {
                    log.info("Initializing Overload Protection Manager Stats");
                }
                smmi.enableSipStats(SipMonitoringManagerImpl.OVERLOAD_PROTECTION_MANAGER, layer, MonitoringLevel.HIGH);
            }
        }
    }
}
