/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.dialogmgmt;

import com.ericsson.ssa.sip.PersistentDialogFragmentManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;

/**
 * In-memory replicating DialogFragmentManager.
 */
public class ReplicationDialogFragmentManager
        extends PersistentDialogFragmentManager
        implements ReplicationManager {

    private static final String APP_ID = "DialogFragmentManager";

    /**
     * Constructor, which registers the new instance with the
     * ReplicationMessageRouter.
     */
    public ReplicationDialogFragmentManager() {
        ReplicationMessageRouter.createInstance().addReplicationManager(
            getApplicationId(), this);
    }

    public String getApplicationId() {
        return APP_ID;
    }

    public void processMessage(ReplicationState message) {
    }

    public void processQueryMessage(ReplicationState message,
                                    String returnInstance) {
    }

    public void repair(long repairStartTime) {
    }

    public void repair(long repairStartTime, boolean checkForStopping) {
    }
    
    public void respondToFailure(String instanceName, boolean checkForStopping) {
        ; //no-op for now
    }

}
