/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.initialization;

import com.ericsson.ssa.config.BaseSipPersistenceStrategyBuilder;
import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.sip.SipApplicationSessionStore;
import com.ericsson.ssa.sip.SipSessionStore;

import com.sun.enterprise.config.serverbeans.SipContainerAvailability;
import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.StoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;

import org.jvnet.glassfish.comms.replication.sessmgmt.ServletTimerStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.ServletTimerStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipApplicationSessionStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipApplicationSessionStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipSessionStoreFactory;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipSessionStoreImpl;
import org.jvnet.glassfish.comms.replication.sessmgmt.SipTransactionPersistentManager;

import java.util.logging.Logger;


public abstract class SipStrategyBuilder
    extends BaseSipPersistenceStrategyBuilder {

    protected abstract void setSessionFactory(SipTransactionPersistentManager mgr);

    public void initializePersistenceStrategy(ConvergedContext ctx,
        SipContainerAvailability sca) {
        SipTransactionPersistentManager mgr = new SipTransactionPersistentManager();
        mgr.setPassedInPersistenceType(getPassedInPersistenceType());

        initializePersistenceStrategy(mgr, ctx, sca);

        setSessionFactory(mgr);

        SipApplicationSessionStore sipApplicationSessionStore = new SipApplicationSessionStoreImpl();
        mgr.setSipApplicationSessionStore(sipApplicationSessionStore);

        SipSessionStore sipSessionStore = new SipSessionStoreImpl();
        mgr.setSipSessionStore(sipSessionStore);

        /*
         * Add StorePools
         */
        ServerConfigReader configReader = new ServerConfigReader();

        int haStorePoolSize = configReader.getHAStorePoolSizeFromConfig();
        int haStorePoolUpperSize = configReader.getHAStorePoolUpperSizeFromConfig();
        int haStorePoolPollTime = configReader.getHAStorePoolPollTimeFromConfig();

        // SipApplicationSession StorePool        
        StoreFactory sipApplicationSessionStoreFactory = new SipApplicationSessionStoreFactory();
        StorePool sipApplicationSessionStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                sipApplicationSessionStoreFactory);
        mgr.setSipApplicationSessionStorePool(sipApplicationSessionStorePool);

        // SipSession StorePool
        StoreFactory sipSessionStoreFactory = new SipSessionStoreFactory();
        StorePool sipSessionStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                sipSessionStoreFactory);
        mgr.setSipSessionStorePool(sipSessionStorePool);

        // ServletTimer StorePool
        StoreFactory servletTimerStoreFactory = new ServletTimerStoreFactory();
        StorePool servletTimerStorePool = new StorePool(haStorePoolSize,
                haStorePoolUpperSize, haStorePoolPollTime,
                servletTimerStoreFactory);
        mgr.setServletTimerStorePool(servletTimerStorePool);

        ctx.setSipSessionManager(mgr);

        // If we are doing replication initialize jxta pipes if they
        // haven't been already
        String passedInPersistenceType = getPassedInPersistenceType();
        if (EEPersistenceTypeResolver.REPLICATED_TYPE.equalsIgnoreCase(
                passedInPersistenceType)) {
            JxtaReplicationReceiver receiver
                = JxtaReplicationReceiver.createInstance();
            receiver.doPipeInitialization();
        } 
    }
}
