/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;

import java.io.*;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.sip.TimerListener;


/**
 * Class representing a replicating ServletTimer.
 */
public class HAServletTimer extends ServletTimerImpl {
    private transient boolean isDirty = false;

    // The version of this ServletTimer
    private transient AtomicLong version;

    private transient ServletTimerExtraParams extraParams;

    /**
     * Constructor for non-repeating timer.
     *
     * @param sas The SipApplicationSession with which this ServletTimer
     * is being associated
     * @param info Information about the timer
     * @param delay Delay until execution
     * @param listener Listener that will get timeout events.
     */
    public HAServletTimer(SipApplicationSessionImpl sas, Serializable info,
        long delay, TimerListener listener) {
        super(sas, info, delay, listener);
        version = new AtomicLong(-1);
        extraParams = new ServletTimerExtraParams(this);
    }

    /**
     * Constructor for repeating times
     *
     * @param sas The SipApplicationSession with which this ServletTimer
     * is being associated
     * @param info Information about the timer
     * @param delay Delay until first execution
     * @param fixedDelay Whether fixed delay mode should be used
     * @param period Period between execution
     * @param listener Listener that will get timeout events.
     */
    public HAServletTimer(SipApplicationSessionImpl sas, Serializable info,
        long delay, boolean fixedDelay, long period, TimerListener listener) {
        super(sas, info, delay, fixedDelay, period, listener);
        version = new AtomicLong(-1);
        extraParams = new ServletTimerExtraParams(this);
    }

    /**
     * Checks whether this session is dirty or not.
     *
     * @return true if this session has been marked as dirty, false otherwise
     */
    public boolean isDirty() {
        return isDirty;
    }

    /**
     * Marks this session as dirty or non-dirty.
     *
     * @param isDirty The dirty flag
     */
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    /**
     * Increments the version of this ServletTimer.
     */
    public void incrementVersion() {
        version.incrementAndGet();
    }

    /**
     * Gets the version of this ServletTimer.
     *
     * @return The version of this ServletTimer
     */
    public long getVersion() {
        return version.get();
    }

    /**
     * Sets the version of this ServletTimer.
     *
     * @value The new version of this ServletTimer
     */
    public void setVersion(long value) {
        version.getAndSet(value);
    }

    public ServletTimerExtraParams getExtraParameters() {
        return extraParams;
    }

    /**
     * Updates this ServletTimer with the given extra 
     * parameters.
     *
     * @param extraParams The extra parameters used to update this
     * ServletTimer
     */
    public void update(ServletTimerExtraParams extraParams) {
        // FIXME
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(version);
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        version = (AtomicLong) in.readObject();
        extraParams = new ServletTimerExtraParams(this);
    }

    protected String getFullyQualifiedId() {
        return fullyQualifiedId + ":version:" + getVersion(); 
    }
}
