/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionManagerBase;

import java.io.*;
import java.util.concurrent.atomic.AtomicLong;

public class HASipApplicationSession extends SipApplicationSessionImpl {
    private transient boolean isDirty = false;

    private transient AtomicLong version;

    private transient SipApplicationSessionExtraParams extraParams;

    /**
     * Constructor.
     */
    public HASipApplicationSession(SipSessionManagerBase manager, String id) {
        super(manager, id);
        version = new AtomicLong(-1);
        extraParams = new SipApplicationSessionExtraParams(this);
    }

    /**
     * Checks whether this session is dirty or not.
     *
     * @return true if this session has been marked as dirty, false otherwise
     */
    public boolean isDirty() {
        return isDirty;
    }

    /**
     * Marks this session as dirty or non-dirty.
     *
     * @param isDirty The dirty flag
     */
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    /**
     * Increments the version of this SipApplicationSession.
     */
    public void incrementVersion() {
        version.incrementAndGet();
    }

    /**
     * Gets the version of this SipApplicationSession.
     *
     * @return The version of this SipApplicationSession
     */
    public long getVersion() {
        return version.get();
    }

    /**
     * Sets the version of this SipApplicationSession.
     *
     * @value The new version of this SipApplicationSession
     */
    public void setVersion(long value) {
        version.getAndSet(value);
    }

    public SipApplicationSessionExtraParams getExtraParameters() {
        return extraParams;
    }

    /**
     * Updates this SipApplicationSession with the given extra 
     * parameters.
     *
     * @param extraParams The extra parameters used to update this
     * SipApplicationSession
     */
    public void update(SipApplicationSessionExtraParams extraParams) {
        // TBD
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(version);
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        version = (AtomicLong) in.readObject();
        extraParams = new SipApplicationSessionExtraParams(this);
    }

    public String toString() {
        return description + ":version:" + getVersion(); 
    }

}
