/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.PathNode.Type;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipSessionManagerBase;

import javax.servlet.sip.Address;
import java.io.*;
import java.util.concurrent.atomic.AtomicLong;

public class HASipSession extends SipSessionDialogImpl {
    private transient boolean isDirty = false;

    // The version of this SipSession
    private transient AtomicLong version;

    private transient SipSessionExtraParams extraParams;

    /**
     * Constructor.
     */
    public HASipSession(SipSessionManagerBase manager, DialogSet set,
        Address to, SipApplicationSessionImpl appSession, String handler,
        Type type) {
        super(manager, set, to, appSession, handler, type);
        version = new AtomicLong(-1);
        extraParams = new SipSessionExtraParams(this);
    }

    /**
     * Checks whether this session is dirty or not.
     *
     * @return true if this session has been marked as dirty, false otherwise
     */
    public boolean isDirty() {
        return isDirty;
    }

    /**
     * Marks this session as dirty or non-dirty.
     *
     * @param isDirty The dirty flag
     */
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    /**
     * Increments the version of this SipSession.
     */
    public void incrementVersion() {
        version.incrementAndGet();
    }

    /**
     * Gets the version of this SipSession.
     *
     * @return The version of this SipSession
     */
    public long getVersion() {
        return version.get();
    }

    /**
     * Sets the version of this SipSession.
     *
     * @value The new version of this SipSession
     */
    public void setVersion(long value) {
        version.getAndSet(value);
    }

    public SipSessionExtraParams getExtraParameters() {
        return extraParams;
    }

    /**
     * Updates this SipSession with the given extra parameters.
     *
     * @param extraParams The extra parameters used to update this
     * SipSession
     */
    public void update(SipSessionExtraParams extraParams) {
        // FIXME
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(version);
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        version = (AtomicLong) in.readObject();
        extraParams = new SipSessionExtraParams(this);
    }

    public String toString() {
        return description + ":version:" + getVersion(); 
    }
}
