/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipSessionManagerBase;


/**
 * Implementation of SipApplicationSession for modified-session persistence
 * scope.
 */
public class ModifiedHASipApplicationSession extends HASipApplicationSession {
    /**
     * Constructor.
     */
    public ModifiedHASipApplicationSession(SipSessionManagerBase manager,
        String id) {
        super(manager, id);
    }

    /**
     * Sets the attribute with the given name to the given value and updates
     * the dirty flag to true
     *
     * @param name The attribute name to set
     * @param value The attribute value to set
     */
    @Override
    public void setPFieldApplicationAttribute(String name, Object value) {
        super.setPFieldApplicationAttribute(name, value);
        setDirty(true);
    }

    /**
     * Removes the attribute with the given name and updates the dirty flag
     * to true
     *
     * @param name The name of the attribute to remove
     */
    @Override
    protected void removePFieldApplicationAttribute(String key) {
        super.removePFieldApplicationAttribute(key);
        setDirty(true);
    }
}
