/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.PathNode.Type;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionManagerBase;

import javax.servlet.sip.Address;


/**
 * Implementation of SipSession for modified-session persistence scope.
 */
public class ModifiedHASipSession extends HASipSession {
    /**
     * Constructor.
     */
    public ModifiedHASipSession(SipSessionManagerBase manager, DialogSet set,
        Address to, SipApplicationSessionImpl appSession, String handler,
        Type type) {
        super(manager, set, to, appSession, handler, type);
    }

    /**
     * Sets the attribute with the given name to the given value and updates
     * the dirty flag to true
     *
     * @param name The attribute name to set
     * @param value The attribute value to set
     */
    @Override
    protected void addToPFieldSessionAttribute(String name, Object value) {
        super.addToPFieldSessionAttribute(name, value);
        this.setDirty(true);
    }

    /**
     * Removes the attribute with the given name and updates the dirty flag
     * to true
     *
     * @param name The name of the attribute to remove
     */
    @Override
    protected void removeFromPFieldSessionAttribute(String name) {
        super.removeFromPFieldSessionAttribute(name);
        this.setDirty(true);
    }

}
