/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import java.io.*;

/**
 * Class containing the extra parameters for a ServletTimer.
 *
 * Extra parameters are parameters that are likely to change very
 * frequently. Rather than having to serialize the entire ServletTimer state
 * when any of the extra parameters change, the extra parameters are
 * serialized and replicated separately from the ServletTimer's state.
 *
 * When a ServletTimer is deserialized on a replica instance, its state is
 * overlayed with the latest version of the corresponding extra parameters.
 *
 * @author jluehe
 * @author lwhite
 */
public class ServletTimerExtraParams implements Serializable {

    private transient String parentSasId;
    private transient String currentOwnerInstanceName;
    private transient long nextExpirationTime;

    // The associated ServletTimer
    private transient final HAServletTimer timer;

    // The id of the associated ServletTimer
    private transient String id;

    private transient int hc;

    /**
     * Constructor
     *
     * @param timer The associated ServletTimer
     */
    public ServletTimerExtraParams(HAServletTimer timer) {
        this.timer = timer;
        this.id = timer.getId();
        this.hc = id.hashCode();
    }

    public String getId() {
        return id;
    }

    public String getParentSasId() {
        if (timer != null) {
            return timer.getApplicationSession().getId();
        } else {
            return parentSasId;
        }
    }

    public String getCurrentOwnerInstanceName() {
        if (timer != null) {
            return ((SipApplicationSessionImpl) timer.getApplicationSession()).getCurrentOwnerInstanceName();
        } else {
            return currentOwnerInstanceName;
        }
    }

    public long getNextExpirationTime() {
        if (timer != null) {
            //return timer.getExpirationTime();
            return -1; // FIXME
        } else {
            return nextExpirationTime;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (! (obj instanceof ServletTimerExtraParams)) {
            return false;
        }

        ServletTimerExtraParams that = (ServletTimerExtraParams) obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return hc;
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(id);
        oos.writeObject(getParentSasId());
        oos.writeObject(getCurrentOwnerInstanceName());
        oos.writeLong(getNextExpirationTime());
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        id = (String) in.readObject();
        hc = id.hashCode();
        parentSasId = (String) in.readObject();
        currentOwnerInstanceName = (String) in.readObject();
        nextExpirationTime = in.readLong();
    }
}
