/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.replication.sessmgmt;

import java.io.*;

/**
 * Class containing the extra parameters for a SipSession.
 *
 * Extra parameters are parameters that are likely to change very
 * frequently. Rather than having to serialize the entire SipSession state
 * when any of the extra parameters change, the extra parameters are
 * serialized and replicated separately from the SipSession's state.
 *
 * When a SipSession is deserialized on a replica instance, its state is
 * overlayed with the latest version of the corresponding extra parameters.
 *
 * @author jluehe
 * @author lwhite
 */
public class SipSessionExtraParams implements Serializable {

    private transient String parentSasId;
    private transient String currentOwnerInstanceName;
    private transient long nextExpirationTime;
    private transient String dialogFragmentId;
    private transient int cseq;

    // The associated SipSession
    private transient final HASipSession sipSession;

    // The id of the associated SipSession
    private transient String id;

    private transient int hc;

    /**
     * Constructor
     *
     * @param sipSession The associated SipSession
     */
    public SipSessionExtraParams(HASipSession sipSession) {
        this.sipSession = sipSession;
        this.id = sipSession.getId();
        this.hc = id.hashCode();
    }

    public String getId() {
        return id;
    }

    public String getParentSasId() {
        if (sipSession != null) {
            return sipSession.getApplicationSession().getId();
        } else {
            return parentSasId;
        }
    }

    public String getCurrentOwnerInstanceName() {
        if (sipSession != null) {
            return sipSession.getCurrentOwnerInstanceName();
        } else {
            return currentOwnerInstanceName;
        }
    }

    public long getNextExpirationTime() {
        if (sipSession != null) {
            //return sipSession.getExpirationTime();
            return -1; // FIXME
        } else {
            return nextExpirationTime;
        }
    }

    public String getDialogFragmentId() {
        if (sipSession != null) {
            //return sipSession.getDialogFragmentId();
            return null; // FIXME
        } else {
            return dialogFragmentId;
        }
    }

    public int getCseq() {
        if (sipSession != null) {
            //return sipSession.getCseq();
            return -1; // FIXME
        } else {
            return cseq;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }

        if (! (obj instanceof SipSessionExtraParams)) {
            return false;
        }

        SipSessionExtraParams that = (SipSessionExtraParams) obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return hc;
    }

    private void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.writeObject(id);
        oos.writeObject(getParentSasId());
        oos.writeObject(getCurrentOwnerInstanceName());
        oos.writeLong(getNextExpirationTime());
        oos.writeObject(getDialogFragmentId());
        oos.writeInt(getCseq());
    }

    private void readObject(ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        id = (String) in.readObject();
        hc = id.hashCode();
        parentSasId = (String) in.readObject();
        currentOwnerInstanceName = (String) in.readObject();
        nextExpirationTime = in.readLong();
        dialogFragmentId = (String) in.readObject();
        cseq = in.readInt();
    }
}
