/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipStore;
import com.sun.appserv.ha.spi.BackingStore;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.WebIOUtilsFactory;

public class SipStoreBase implements SipStore {

    protected SipSessionManager manager;
    
    /**
     * A utility class used to call into services from IOUtils
     */
    private IOUtilsCaller webUtilsCaller = null;    

    /**
     * Gets the session manager of this store.
     *
     * @return The session manager of this store
     */
    public SipSessionManager getSipSessionManager() {
        return manager;
    }

    /**
     * Sets the session manager for this store.
     *
     * @param manager The session manager for this store.
     */
    public void setSipSessionManager(SipSessionManager manager) {
        this.manager = manager;
    }
    
    protected String getApplicationId() {
        return this.getSipSessionManager().getApplicationId();
    } 
    
    /**
    * Create an byte[] for the session that we can then pass to
    * the Store.
    *
    * @param obj - used for SipApplicationSession, SipSession, ServletTimer
    *   The object we are serializing
    *
    */
    protected byte[] getByteArray(Object obj)
      throws IOException {
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        byte[] obs;
        try {
            bos = new ByteArrayOutputStream();            
            if( (utilsCaller = this.getWebUtilsCaller()) != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream(new BufferedOutputStream(bos), true);
                } catch (Exception ex) {}
            }
            //use normal ObjectOutputStream if there is a failure during stream creation
            if(oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos)); 
            }            

            writeObject(obj, oos);
            oos.close();
            oos = null;

            obs = bos.toByteArray();
        }
        finally {
            if ( oos != null )  {
                oos.close();
            }
        }

        return obs;
    }
    
    public void writeObject(Object obj, ObjectOutputStream oos)
        throws IOException {
      if ( obj == null )  {
        return;
      }      
      oos.writeObject(obj);
    }     
    
    /**
     * get the utility class used to call into services from IOUtils
     */
    protected IOUtilsCaller getWebUtilsCaller() {
        if(webUtilsCaller == null) {
            WebIOUtilsFactory factory = new WebIOUtilsFactory();
            webUtilsCaller = factory.createWebIOUtil();            
        }
        return webUtilsCaller;
    }    

}
