/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.util;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.deployment.runtime.common.PrincipalNameDescriptor;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;

import java.security.PrivilegedExceptionAction;

import java.util.List;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyConfigurationFactory;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class PolicyBuilder {
    String trustClassName = null;

    public PolicyConfiguration getInstance(String contextId)
        throws PolicyContextException {
        PolicyConfigurationFactory pfi = null;
        try{
         pfi = PolicyConfigurationFactory.getPolicyConfigurationFactory();                
        }catch(java.lang.ClassNotFoundException cne){
            throw new PolicyContextException(cne);
        }
        return pfi.getPolicyConfiguration(contextId, false);
    }

    public void createRoleMapper(BundleDescriptor descriptor, String name) {
        if (descriptor instanceof WebBundleDescriptor) {
            SecurityRoleMapping[] srmList = ((WebBundleDescriptor) descriptor).getSunDescriptor()
                                             .getSecurityRoleMapping();
            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();

            //  super.getDescriptor().getApplication().getRoleMapper().getName();
            if (srmList == null) {
                return;
            }

            for (int si = 0; si < srmList.length; si++) {
                SecurityRoleMapping srm = srmList[si];
                Role role = new Role(srm.getRoleName());
                SecurityRoleMapper rm = factory.getRoleMapper(name);

                if (rm != null) {
                    List<PrincipalNameDescriptor> principals = srm.getPrincipalNames();

                    for (int i = 0; i < principals.size(); i++) {
                        rm.assignRole(principals.get(i).getPrincipal(), role,
                            descriptor);
                    }

                    List<String> groups = srm.getGroupNames();

                    for (int i = 0; i < groups.size(); i++) {
                        rm.assignRole(new Group(groups.get(i)), role, descriptor);
                    }
                }
            }
        }
    }

    public void setPolicyContext(final String ctxID) throws Throwable {
        String old = PolicyContext.getContextID();

        try {
            AppservAccessController.doPrivileged(new PrivilegedExceptionAction() {
                    public java.lang.Object run() throws Exception {
                        PolicyContext.setContextID(ctxID);

                        return null;
                    }
                });
        } catch (java.security.PrivilegedActionException pae) {
            Throwable cause = pae.getCause();

            //log exception.
            throw cause;
        }
    }

    //    public void getValidator() throws ConfigException {
    //
    //        ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    //        ctx.getRootConfigBean();
    //        get com;
    //        sun.enterprise.config.serverbeans.LoadBalancers loadbalancers = ((Domain) ctx.getRootConfigBean()).getLoadBalancers();
    //        if (loadbalancers == null) {
    //            return;
    //        }
    //        com.sun.enterprise.config.serverbeans.LoadBalancer[] lbs = loadbalancers.getLoadBalancer();
    //    }
}
