/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.sip.SipSessionManagerBase;

import com.sun.enterprise.config.serverbeans.SipContainerAvailability;

import java.util.logging.Logger;


/**
 * @author jluehe
 */
public abstract class BaseSipPersistenceStrategyBuilder
    implements SipPersistenceStrategyBuilder {
    protected Logger logger;

    private String passedInPersistenceType;

    protected void initializePersistenceStrategy(SipSessionManagerBase mgr,
        ConvergedContext ctx, SipContainerAvailability sca) {
        if (sca != null) {
            mgr.setRepairDuringFailure(sca.isRepairDuringFailure());
        }

        SipApplication sipApplication = ctx.getSipApplication();

        if (sipApplication != null) {
            mgr.setSessionTimeout(sipApplication.getSessionConfigTimeout());
        }
    }

    public String getPassedInPersistenceType() {
        return passedInPersistenceType;
    }    
    
    public void setPassedInPersistenceType(String persistenceType) {
        passedInPersistenceType = persistenceType;
    }    

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}
