/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.event.ConfigEventMulticaster;


/**
 * Configuration interface
 *
 * @author eandbur
 * @since Apr 16, 2007
 *
 */
public interface Config {
    public static final String GLOBAL_NODE = "GLOBAL";

    /**
     * Set the value for a configuration key in the configuration repository.
     *
     * @param key
     * @param value
     */
    public void set(String key, String value);

    /**
     * Set the value of a configuration key for a certain node in the
     * configuration repository. The configuration key will be set on global
     * level if node equals GLOBAL_NODE.
     *
     * @param node
     * @param key
     * @param value
     */
    public void set(String node, String key, String value);

    /**
     * Get the value of a configuration key from the configuration repository.
     *
     * @param key
     * @return
     */
    public String get(String key);

    /**
     * Get the value of a configuration key for a certain node from the
     * configuration repository.
     *
     * @param node
     * @param key
     * @return
     */
    public String get(String node, String key);

    String[] getChildNames(String node);

    /**
     * Clear all specific configuration for this node.
     */
    public void clear();

    /**
     * Clear all configuration.
     */
    public void clearAll();

    /**
     * Clear all node specific configuration.
     *
     * @param node
     */
    public void clear(String node);

    /**
     * Remove node including childeren.
     *
     * @param node
     */
    public void remove(String node);

    /**
     * Copy all node specific configuration to another node.
     *
     * @param fromNode
     * @param toNode
     */
    public void copyConfig(String fromNode, String toNode);

    void setEventMulticaster(ConfigEventMulticaster eventMulticaster);
}
