/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.event.ConfigChangeListener;
import com.ericsson.ssa.config.event.ConfigEventMulticaster;
import com.ericsson.ssa.config.event.ConfigEventRegistry;


/**
 * ConfigFactory used to fetching an instance of the Config interface.
 *
 * @author eandbur
 * @since Apr 16, 2007
 *
 */
public class ConfigFactory extends ConfigEventMulticaster {
    private static final ConfigFactory INSTANCE = new ConfigFactory();
    private Config _config = null;

    public static ConfigFactory instance() {
        return INSTANCE;
    }

    /**
     * Fetch a instance of Config.
     *
     * @return
     */
    public static Config getConfig() {
        return INSTANCE._config;
    }

    public void registerConfig(Config config) {
        _config = config;
        _config.setEventMulticaster(this);
    }

    public void deregisterConfig() {
        if (_config != null) {
            _config.setEventMulticaster(null);
            _config = null;
        }
    }
}
