/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.event.ConfigEventMulticaster;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;


/**
 * TODO Add comments (class description)
 *
 *
 * @author eandbur
 * @since Apr 17, 2007
 *
 */
public class ConfigImpl implements Config {
    public static final String CONFIG_PATH = "/com/ericsson/eas/cluster/config";
    private static String _id = System.getProperty("HostNumber");
    private static Logger _log = Logger.getLogger("SipContainer");
    public static Preferences _config = Preferences.userRoot().node(CONFIG_PATH);
    private ConfigEventMulticaster eventMulticaster;

    public void clearAll() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "clearAll()");
        }

        try {
            _config.clear();
        } catch (BackingStoreException e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    public void clear() {
        clear(_id);
    }

    public void clear(String node) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "clear() " + node);
        }

        try {
            for (String key : _config.node(node).keys()) {
                _config.node(node).remove(key);
            }
        } catch (BackingStoreException e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    public String get(String key) {
        return get(_id, key);
    }

    public String get(String node, String key) {
        if (node == null) {
            throw new IllegalArgumentException("Invalid id=null" +
                " when retriving parameter=" + key);
        }

        String value = System.getProperty(key);

        if (value != null) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE,
                    "The parameter=" + key +
                    " was retrived as a -D flag with the value=" + value);
            }

            return value;
        }

        value = _config.node(node).get(key, null);

        if (value != null) {
            return value;
        }

        value = _config.get(key, null);

        if (value != null) {
            return value;
        }

        _log.log(Level.SEVERE,
            "get(" + node + ", " + key + ") throws RuntimeException");

        throw new RuntimeException(
            "Unable to read configuration parameter for id=" + node +
            ", parameter=" + key);
    }

    public String[] getChildNames(String node) {
        return null;
    }

    public void set(String key, String value) {
        set(_id, key, value);
    }

    public void set(String node, String key, String value) {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "set() " + node + "." + key + "=" + value);
        }

        if (node.equals(GLOBAL_NODE)) {
            _config.put(key, value);
        } else {
            _config.node(node).put(key, value);
        }
    }

    public void copyConfig(String fromNode, String toNode) {
        try {
            for (String param : _config.node(fromNode).keys()) {
                String value = _config.node(fromNode).get(param, null);
                _config.node(toNode).put(param, value);

                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE,
                        "copyConfig() " + param + "=" + value + " " + fromNode +
                        ">" + toNode);
                }
            }
        } catch (BackingStoreException e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    public void remove(String node) {
        try {
            _config.node(node).removeNode();
        } catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void setEventMulticaster(ConfigEventMulticaster anEventMulticaster) {
        eventMulticaster = anEventMulticaster;
    }
}
