/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.dd.ModuleDeployException;
import com.ericsson.ssa.sip.Layer;

import com.sun.org.apache.commons.digester.Digester;

import org.xml.sax.SAXException;

import java.io.IOException;
import java.io.InputStream;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * Dispatcher handler is a singelton which maintains the list of dispatchers. A
 * dispatcher is a SIP processing element and determines the processing of SIP
 * messages in the container. Dispatchers are configurable and defined in a xml
 * file. DispatcherHAndler distinguishes between the following types of
 * dispatchers. TransportDispatcher Represents the entry point for SIP i.e. and
 * has a listening port for SIP. TransactionDispatcher Represents the entry
 * point to the transaction layer, in the case the container is configured to
 * run in "transaction" mode ApplicationDispatcher Represent the interface pont
 * between the SIP stack and the container. Dispatcher
 */
public final class LayerHandler {
    private static LayerHandler layerHandlerInstance = new LayerHandler();
    private Logger m_Log = (Logger) Logger.getLogger("SipContainer");
    private ArrayList<Layer> m_layers = new ArrayList<Layer>();

    /**
     * @return The singelton of LayerHandler
     */
    public static LayerHandler getInstance() {
        return layerHandlerInstance;
    }

    /**
     * Returns the stored chain of layers as a shallow copy.
     *
     * @return the stored chain of layers as a shallow copy.
     */
    public List<Layer> getLayers() {
        return new ArrayList<Layer>(m_layers);
    }

    /**
     * Stores the layers in a List and link the new Layer to the Last stored
     * layer
     *
     * @param nextLayer
     */
    public void addLayer(Layer nextLayer) {
        int currentSize = m_layers.size();

        if (currentSize > 0) {
            Layer currentLayer = m_layers.get(currentSize - 1);
            currentLayer.registerNext(nextLayer);
        }

        m_layers.add(nextLayer);
    }

    /**
     * parse the list of dispatchers
     */
    public void parse(InputStream digesterDescriptor)
        throws IOException, ModuleDeployException, SAXException {
        try {
            m_layers.clear();

            Digester digester = new Digester();
            digester.setClassLoader(LayerHandler.class.getClassLoader());
            digester.setValidating(false);
            digester.addRule("*/dispatcher", new LayerRule());
            digester.parse(digesterDescriptor);
        } catch (Exception e) {
            m_Log.log(Level.WARNING, "Failed in parsing dispatcher.xml", e);
        }
    }
}
