/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.container.mbeans.Constants;
import com.ericsson.ssa.container.mbeans.MBeanUtil;

// import javax.servlet.sip.ServletTimer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;


// import com.ericsson.ssa.sip.timer.ServletTimerImpl;
// import com.ericsson.ssa.sip.timer.TimerServiceImpl;

/**
 *
 * @author john doe
 * @reviewed ejoelbi 2007-jan-17
 */
public abstract class RuntimeConfig extends TimerTask {
    /*
     * Delay (in milliseconds) before task to check parameters is executed
     */
    private static final Long DELAY = 0L;

    /*
     * Time interval used before checking for updated parameters
     */
    private static final Long CHECKINTERVAL = 60000L;
    Logger _logger = Logger.getLogger("SipContainer");
    private Timer m_timerMonitor = new Timer();

    public void loadRuntimeConfiguration() {
        MBeanServer server = MBeanUtil.getInstance().getServer();

        // Configure Network Manager
        try {
            // Sequencing matters here .. some pieces depend on others

            // Configure NetworkManager
            ObjectName oname = new ObjectName(Constants.NETWORK_MANAGER);
            AttributeList attrList = new AttributeList();
            Attribute attrib = null;

            attrList.addAll(getInitialParams());
            attrList.addAll(getRuntimeParams());

            server.setAttributes(oname, attrList);

            // Configure for JMX
            oname = new ObjectName(Constants.JMX_CONFIGURATION);
            attrList = new AttributeList();

            attrib = new Attribute(Constants.JMX_DEFAULT_HOST,
                    getJMXDefaultHost());
            attrList.add(attrib);

            attrib = new Attribute(Constants.JMX_DEFAULT_PORT,
                    Integer.valueOf(getJMXDefaultPort()));
            attrList.add(attrib);

            server.setAttributes(oname, attrList);

            //TODO  Dissable runtime parameters for now, Admin team to enable when FSD is done //Stoffe 
            //m_timerMonitor.schedule(this, DELAY, CHECKINTERVAL);
        } catch (Exception e) {
            _logger.log(Level.SEVERE, "Failed loading properties", e);
            e.printStackTrace();
        }
    }

    /**
     * Gets parameters that are runtime changeable.
     */
    private AttributeList getRuntimeParams() {
        AttributeList attrList = new AttributeList();
        Attribute attrib = null;

        attrib = new Attribute(Constants.OVERLOAD_REGULATION,
                getOverloadRegulation());
        attrList.add(attrib);

        attrib = new Attribute(Constants.HTTP_THRESHOLD, getHttpThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.IR_THRESHOLD, getIrThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.SR_THRESHOLD, getSrThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.MM_THRESHOLD, getMmThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.SAMPLE_RATE, getSampleRate());
        attrList.add(attrib);

        attrib = new Attribute(Constants.NUMBER_OF_SAMPLES, getNumberOfSamples());
        attrList.add(attrib);

        return attrList;
    }

    /**
     * Gets parameters that are installation changeable.
     */
    private AttributeList getInitialParams() {
        AttributeList attrList = new AttributeList();
        Attribute attrib = null;

        attrib = new Attribute(Constants.APP_DISPATCHER_LOOP_INTERNAL,
                Boolean.valueOf(getApplicationDispatcherLoopInternal()));
        attrList.add(attrib);

        attrib = new Attribute(Constants.ERROR_RESPONSE_ENABLED,
                Boolean.valueOf(getErrorResponseEnabled()));
        attrList.add(attrib);

        attrib = new Attribute(Constants.HOST_NUMBER,
                Integer.valueOf(getHostNumber()));
        attrList.add(attrib);

        attrib = new Attribute(Constants.DEFAULT_TCP_TRANSPORT,
                Boolean.valueOf(getDefaultTCPTransport()));
        attrList.add(attrib);

        attrib = new Attribute(Constants.LAN_ADDRESS, getLanAddress());
        attrList.add(attrib);

        attrib = new Attribute(Constants.THREAD_POOL_SIZE,
                Integer.valueOf(getThreadPoolSize()));
        attrList.add(attrib);

        attrib = new Attribute(Constants.ENUM_TOPDOMAIN, getEnumTopDomain());
        attrList.add(attrib);

        attrib = new Attribute(Constants.TIMER_T1, getTimerT1());
        attrList.add(attrib);

        attrib = new Attribute(Constants.TIMER_T2, getTimerT2());
        attrList.add(attrib);

        attrib = new Attribute(Constants.TIMER_T4, getTimerT4());
        attrList.add(attrib);

        attrib = new Attribute(Constants.PROXY_POOL_SIZE, getProxyPoolSize());
        attrList.add(attrib);

        attrib = new Attribute(Constants.PROXY_RETRIES, getProxyRetries());
        attrList.add(attrib);

        attrib = new Attribute(Constants.PROXY_SOCKET_TIMEOUT,
                getProxySocketTimeout());
        attrList.add(attrib);

        attrib = new Attribute(Constants.PROXY_CONNECTION_TIMEOUT,
                getProxyConnectionTimeout());
        attrList.add(attrib);

        attrib = new Attribute(Constants.OVERLOAD_REGULATION,
                getOverloadRegulation());
        attrList.add(attrib);

        attrib = new Attribute(Constants.SAMPLE_RATE, getSampleRate());
        attrList.add(attrib);

        attrib = new Attribute(Constants.NUMBER_OF_SAMPLES, getNumberOfSamples());
        attrList.add(attrib);

        attrib = new Attribute(Constants.HTTP_THRESHOLD, getHttpThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.IR_THRESHOLD, getIrThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.SR_THRESHOLD, getSrThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.MM_THRESHOLD, getMmThreshold());
        attrList.add(attrib);

        attrib = new Attribute(Constants.CPU_ALARM_ENABLED, getCpuAlarmEnabled());
        attrList.add(attrib);

        attrib = new Attribute(Constants.CPU_ALARM_THRESHOLD,
                getCpuAlaramThreshold());
        attrList.add(attrib);

        // Actually a property in ResolverManager. Reflection will make attempt
        // to set it at ResolverManager since it is a Layer.
        attrib = new Attribute(Constants.EAS_503_DISABLED,
                Boolean.valueOf(getEas503Disabled()));
        attrList.add(attrib);

        return attrList;
    }

    /**
     * Uninitializes parameters that are runtime changeable.
     */
    public abstract void uninitialize();

    /**
     * Read the parameters that can be changed in runtime again.
     */
    synchronized public void run() {
        MBeanServer server = MBeanUtil.getInstance().getServer();

        // Reset the parameters to get ConfigManager to re-read them.
        uninitialize();

        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Load runtime parameters again.");
            }

            ObjectName oname = new ObjectName(Constants.NETWORK_MANAGER);

            server.setAttributes(oname, getRuntimeParams());
        } catch (Exception e) {
            _logger.log(Level.SEVERE,
                "Failed loading updated runtime properties", e);
            e.printStackTrace();
        }
    }

    /**
     * Terminates the timer. Any scheduled task will be discarded. This stops the
     * check of all configuration parameters, and thus notifications about
     * parameter value changes will no longer be sent.
     */
    protected void destroy() {
        m_timerMonitor.cancel();
    }

    /**
    /**
     * @return
     */
    public abstract int getThreadPoolSize();

    /**
     * @return
     */
    public abstract String getJMXDefaultHost();

    /**
     * @return
     */
    public abstract int getJMXDefaultPort();

    /**
     * Multiprocessor environment usage. Used to calculate the subsequent port
     *
     * @return
     */
    public abstract int getHostNumber();

    /**
     * Get the value for the parameter <code>defaultTCPTransport</code>.
     *
     * @return true if TCP should be used false if UDP.
     */
    public abstract boolean getDefaultTCPTransport();

    /**
     * Multiprocessor environment usage. Returns the internal LAN address.
     *
     * @return
     */
    public abstract String getLanAddress();

    /**
     * Allow ApplicationDispatcher to loop internally between the apps (true).
     */
    public abstract boolean getApplicationDispatcherLoopInternal();

    /**
     * Returns the topdomain to be used for ENUM dns lookups.
     *
     * @return Returns the topdomain to be used for ENUM dns lookups
     */
    public abstract String getEnumTopDomain();

    /**
     *
     *
     *
    /**
     * Returns the value of SIP Timer T1.
     *
     * @return value of Timer T1 in ms
     */
    public abstract int getTimerT1();

    /**
     * Returns the value of SIP Timer T2.
     *
     * @return value of Timer T2 in ms
     */
    public abstract int getTimerT2();

    /**
     * Returns the value of SIP Timer T4.
     *
     * @return value of Timer T4 in ms
     */
    public abstract int getTimerT4();

    /**
    /**
     * The HTTP proxy connection pool size.
     *
     * @return The size of the connection pools.
     */
    public abstract int getProxyPoolSize();

    /**
     * Returns the maximum number of retries that
     * the HTTP proxy will do for each request.
     *
     * @return The maximum number of retries.
     */
    public abstract int getProxyRetries();

    /**
     * Returns the socket read timeout value in milliseconds.
     * This value is used as the maximum time the proxy
     * will wait for a response before considering the
     * proxy attempt to have failed.
     *
     * @return The socket read timeout value in milliseconds.
     */
    public abstract int getProxySocketTimeout();

    /**
     * Returns the timeout value in milliseconds used
     * when the proxy tries to obtain a connection from
     * a connection pool.
     *
     * @return The timeout value.
     */
    public abstract int getProxyConnectionTimeout();

    /**
     * Returns a boolean indicating if the overload regulation
     * is enabled or disabled.
     *
     * @return Enabled or disabled
     */
    public abstract boolean getOverloadRegulation();

    /**
     * Returns the sample rate in seconds
     *
     * @return The sample rate value
     */
    public abstract int getSampleRate();

    /**
     * Returns the number of samples to above the threshold
     * value to be able to trigger overload protection functionality
     *
     * @return The number of samples value.
     */
    public abstract int getNumberOfSamples();

    /**
     * Returns the threshold value in procentage for HTTP.
     *
     * @return The threshold value.
     */
    public abstract int getHttpThreshold();

    /**
     * Returns the threshold value in percentage.
     * The level of the cpu for initial sip requests.
     *
     * @return The threshold value.
     */
    public abstract int getIrThreshold();

    /**
     * Returns the threshold value in percentage.
     * The level of the cpu for subsequent sip requests.
     *
     * @return The threshold value.
     */
    public abstract int getSrThreshold();

    /**
     * Returns the threshold value in percentage.
     * The level of the cpu for all messages.
     *
     * @return The threshold value.
     */
    public abstract int getMmThreshold();

    /**
     * Returns a boolean indicating if the CPU alarm
     * is enabled or disabled.
     *
     * @return Enabled or disabled
     */
    public abstract boolean getCpuAlarmEnabled();

    /**
     * Returns the CPU threshold value in percentage.
     * The level of the CPU in total.
     *
     * @return The value of CPU threshold
     */
    public abstract int getCpuAlaramThreshold();

    /**
    /**
     * Whether the network manager should send a proper error response if input is
     * malformed. Otherwise the network manager will just be silent.
     */
    public abstract boolean getErrorResponseEnabled();

    /**
     * Defines timeout value in milliseconds for a single write operation of a
     * sip link.
     *
     * @return timeout for write operation of a sip link
     */
    public abstract int getSipLinkTimeout();

    /**
     * Defines the number of retries to perform of a single write operation of a
     * sip link.
     * </p>
     * The maximum time a link will try for success of a write operation is
     * defined by SipLinkTimeout * SipLinkTimeoutRetries milliseconds.
     *
     * @return the number of retries to perform of a single write operation of a
     *         sip link.
     */
    public abstract int getSipLinkTimeoutRetries();

    /**
     * Defines the maximum number simultaneous write/connect requests that can be
     * waiting to write on a link.
     *
     * @return the maximum number simultaneous write/connect requests that can be
     *         waiting to write on a link.
     */
    public abstract int getSipLinkMaxQueueLength();

    /**
     * Defines the duration (in seconds) an inactive SIP link is kept alive before the connection is torn down.
     *
     * @return  the duration (in seconds) an inactive SIP link is kept alive before the connection is torn down.
     */
    public abstract int getSipLinkAliveTimeout();

    /**
     * Determines if the functionality described in RFC3263 4.3 Details of RFC 2782 Process is disabled.
     *
     */
    public abstract boolean getEas503Disabled();
}
