/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import org.apache.naming.resources.WARDirContext;

import java.io.File;

import java.util.zip.ZipFile;


/**
 * SAR Directory Context implementation.
 *
 * @author Pierre Sandstr�m, epiesan
 */
public class SARDirContext extends WARDirContext {
    /**
     * Set the document root.
     *
     * @param docBase The new document root
     *
     * @exception IllegalArgumentException if the specified value is not
     *  supported by this implementation
     * @exception IllegalArgumentException if this would create a
     *  malformed URL
     */
    @Override
    public void setDocBase(String docBase) {
        // Validate the format of the proposed document root
        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }

        if (!(docBase.endsWith(".sar"))) {
            throw new IllegalArgumentException(
                "Doc base must point to a SAR file");
        }

        // Calculate a File object referencing this document base directory
        File base = new File(docBase);

        // Validate that the document base is an existing directory
        if (!base.exists() || !base.canRead() || base.isDirectory()) {
            throw new IllegalArgumentException(
                "Invalid or unreadable SAR file : " + docBase);
        }

        try {
            this.base = new ZipFile(base);
        } catch (Exception e) {
            throw new IllegalArgumentException(
                "Invalid or unreadable SAR file : " + e.getMessage());
        }

        if (docBase == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        } else {
            this.docBase = docBase;
        }

        loadEntries();
    }
}
