/*
 * ConfigAddEvent.java
 *
 * Created on August 29, 2007, 10:35 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package com.ericsson.ssa.config.event;

import com.ericsson.ssa.config.Config;

import java.util.EventObject;


/**
 *
 * @author ELNELBO
 */
public class ConfigAddEvent extends EventObject implements ConfigEvent {
    public static final String TYPE = ConfigAddEvent.class.getName();
    private String node;
    private String parentNode;

    /** Creates a new instance of ConfigAddEvent */
    public ConfigAddEvent(Config config, String aParentNode, String aNode) {
        super(config);
        parentNode = aParentNode;
        node = aNode;
    }

    public String getNode() {
        return node;
    }

    public String getParentNode() {
        return parentNode;
    }

    public String getType() {
        return TYPE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if ((obj == null) || (obj.getClass() != getClass())) {
            return false;
        }

        ConfigAddEvent other = (ConfigAddEvent) obj;

        return ((node == null) && (other.node == null)) ||
        ((node != null) && node.equals(other.node));
    }

    public int hashCode() {
        int hash = 7;
        hash = (31 * hash) + ((node == null) ? 0 : node.hashCode());

        return hash;
    }
}
