/*
 * ConfigEventMulticaster.java
 *
 * Created on August 29, 2007, 9:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package com.ericsson.ssa.config.event;

import java.util.HashMap;
import java.util.Map;


/**
 *
 * @author ELNELBO
 */
public class ConfigEventMulticaster implements ConfigEventRegistry {
    protected Map<ConfigChangeListener, String> registry = new HashMap<ConfigChangeListener, String>();

    /**
     * Creates a new instance of ConfigEventMulticaster
     */
    public ConfigEventMulticaster() {
    }

    public void registerConfigChangeListener(String nodePattern,
        ConfigChangeListener listener) {
        registry.put(listener, nodePattern);
    }

    public void deregisterConfigChangeListener(ConfigChangeListener listener) {
        registry.remove(listener);
    }

    public void processEvent(ConfigEvent event) {
        Map<ConfigChangeListener, String> registryClone = new HashMap<ConfigChangeListener, String>(registry);

        for (Map.Entry<ConfigChangeListener, String> entry : registryClone.entrySet()) {
            if (match(entry.getValue(), event)) {
                System.out.println("processEvent    match :) for " +
                    event.getClass().getName() + " with " + entry.getValue() +
                    " and " + event.getNode());

                if (event instanceof ConfigAddEvent) {
                    entry.getKey().handleConfigEvent((ConfigAddEvent) event);
                }

                if (event instanceof ConfigUpdateEvent) {
                    entry.getKey().handleConfigEvent((ConfigUpdateEvent) event);
                }

                if (event instanceof ConfigRemoveEvent) {
                    entry.getKey().handleConfigEvent((ConfigRemoveEvent) event);
                }
            } else {
                System.out.println("processEvent no match :( for " +
                    event.getClass().getName() + " with " + entry.getValue() +
                    " and " + event.getNode());
            }
        }
    }

    protected boolean match(String nodePattern, ConfigEvent event) {
        return event.getNode().matches(nodePattern);
    }
}
