/*
 * ConfigUpdateEvent.java
 *
 * Created on August 28, 2007, 5:08 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package com.ericsson.ssa.config.event;

import com.ericsson.ssa.config.*;

import java.util.EventObject;


/**
 *
 * @author ELNELBO
 */
public class ConfigUpdateEvent extends EventObject implements ConfigEvent {
    public static final String TYPE = ConfigUpdateEvent.class.getName();
    private String node;

    /** Creates a new instance of ConfigUpdateEvent */
    public ConfigUpdateEvent(Config config, String aNode) {
        super(config);
        node = aNode;
    }

    public String getNode() {
        return node;
    }

    public String getType() {
        return TYPE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if ((obj == null) || (obj.getClass() != getClass())) {
            return false;
        }

        ConfigUpdateEvent other = (ConfigUpdateEvent) obj;

        return ((node == null) && (other.node == null)) ||
        ((node != null) && node.equals(other.node));
    }

    public int hashCode() {
        int hash = 7;
        hash = (31 * hash) + ((node == null) ? 0 : node.hashCode());

        return hash;
    }
}
