/*
 * Lease.java
 *
 * Created on August 28, 2007, 8:35 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package com.ericsson.ssa.config.lease;


/**
 *
 * @author ELNELBO
 */
public class Lease<E> {
    private E resource;
    private String leaseCtx;
    private LeaseGranter leaseGranter;
    private boolean expired;

    public Lease(E aResource, String aLeaseCtx, LeaseGranter aLeaseGranter) {
        resource = aResource;
        leaseCtx = aLeaseCtx;
        leaseGranter = aLeaseGranter;
    }

    public E getResource() throws LeaseExpiredException {
        if (expired) {
            throw new LeaseExpiredException();
        }

        return resource;
    }

    public String getLeaseCtx() {
        return leaseCtx;
    }

    public boolean renew() {
        return leaseGranter.renew(this);
    }

    public void cancel() {
        leaseGranter.cancel(this);
        revoke();
    }

    void revoke() {
        expired = true;
    }
}
