/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;


/**
 * This class holds all configuration parameters for the HttpProxy.
 *
 * @author epiesan
 * @since May 11, 2006
 */
public class HttpProxySettings {
    private int poolSize;
    private int retries;
    private int socketTimeout;
    private int connectionTimeout;

    /**
     * Returns the size of the connection pool for each host.
     *
     * @return Returns the size of the connection pool that
     *   are created by the proxy.
     */
    public int getPoolSize() {
        return poolSize;
    }

    /**
     * Set the size of the connection pool for each host.
     *
     * @param poolSize The size of the connection pool that
     *   are created by the proxy.
     */
    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    /**
     * Returns the timeout value in milliseconds used
     * when the proxy tries to obtain a connection from
     * a connection pool.
     *
     * @return The timeout value.
     */
    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    /**
     * Sets the timeout value in milliseconds used
     * when the proxy tries to obtain a connection from
     * a connection pool.
     *
     * @param connectionTimeout The timeout value in milliseconds.
     */
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /**
     * Returns the maximum number of retries that the proxy
     * will do for each request.
     *
     * @return The maximum number of retries.
     */
    public int getRetries() {
        return retries;
    }

    /**
     * Sets the maximum number of retries that the proxy
     * will do for each request.
     *
     * @param retries The maximum number of retries.
     */
    public void setRetries(int retries) {
        this.retries = retries;
    }

    /**
     * Returns the socket read timeout value in milliseconds.
     * This value is used as the maximum time the proxy
     * will wait for a response before considering the
     * proxy attempt to have failed.
     *
     * @return The socket read timeout value in milliseconds.
     */
    public int getSocketTimeout() {
        return socketTimeout;
    }

    /**
     * Sets the socket read timeout value in milliseconds.
     * This value is used as the maximum time the proxy
     * will wait for a response before considering the
     * proxy attempt to have failed.
     *
     * @param socketTimeout The timeout value in milliseconds.
     */
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}
