/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.dns.TargetTuple;

import java.io.IOException;

import java.net.InetSocketAddress;

import java.nio.channels.SelectableChannel;

import java.util.logging.Level;

import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.TimerListener;


/**
 * This is a link of a supported transport
 *
 * @author ehsroha
 * @reveiwed ehsroha 2006-nov-14
 */
public interface Link extends Dispatcher, Runnable, TimerListener {
    /**
     * Indicate that this link has been used and should stay open for yet a while.
     */
    public void markAsActive();

    /**
     * Returns the type of transport supported by this Link e.g. UDP, TCP, TLS,
     * etc.
     *
     * @return the type of transport supported by this Link e.g. UDP, TCP, TLS,
     *         etc.
     */
    public String getTransport();

    /**
     * Returns the target tuple of this link
     *
     * @return the target tuple of this link
     */
    public TargetTuple getTargetTuple();

    /**
     * Tells whether or not this link is open for communication.
     *
     * @return true if, and only if, this link is open
     */
    public boolean isOpen();

    /**
     * Prepares this link for communication
     *
     * @throws IOException
     */
    public void open() throws IOException;

    /**
     * {@inheritDoc}
     */
    public void timeout(ServletTimer timer);

    /**
     * Ends this link for communication
     *
     * @throws IOException
     */
    public void close() throws IOException;

    /**
     * Returns the underlaying selectable channel used by this link
     *
     * @return the underlaying selectable channel used by this link
     */
    public SelectableChannel getSelectableChannel();

    /**
     * Returns the address of the local endpoint this socket is bound to, or null
     * if it is not bound yet.
     *
     * @return the address of the local endpoint this socket is bound to, or null
     *         if it is not bound yet.
     */
    public InetSocketAddress getLocal();

    /**
     * Returns the address of the endpoint this socket is connected to, or null
     * if it is unconnected.
     *
     * @return the address of the endpoint this socket is connected to, or null
     *         if it is unconnected.
     */
    public InetSocketAddress getRemote();

    /**
     * Returns info about this link
     *
     * @return info about this link
     */
    public String getInfo();
}
