/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;


public abstract class NetworkManager implements Layer {
    private static NetworkManager instance = null;

    public abstract void next(SipServletRequestImpl req);

    public abstract void next(SipServletResponseImpl resp);

    public abstract void registerNext(Layer layer);

    public abstract void dispatch(SipServletRequestImpl req);

    public abstract void dispatch(SipServletResponseImpl resp);

    public synchronized static NetworkManager getInstance() {
        if (instance == null) {
            //TODO remove in final version so only one Network manager is present
            if (Boolean.getBoolean("sip.network.grizzly")) {
                if (Boolean.getBoolean("sip.module.use_new_config")) {
                    instance = new CtxAwareGrizzlyNetworkManager();
                } else {
                    instance = new GrizzlyNetworkManager();
                }
            } else {
                if (Boolean.getBoolean("sip.module.use_new_config")) {
                    throw new IllegalStateException(
                        "New config is only applicable in combination with grizzly: Set the 'sip.network.grizzly' flag.");
                } else {
                    instance = new OLDNetworkManager();
                }
            }
        }

        return instance;
    }

    public boolean isRunning() {
        return true;
    }
}
