/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * MBean to display counters for Overload situations.
 *
 * @author erafope
 * @since Jan 18, 2007
 *
 * @reviewed ehswolm 2007-feb-23
 */
public class OverloadManager {
    private static OverloadManager singleton = new OverloadManager();
    private static final Logger _log = (Logger) Logger.getLogger("SipContainer");
    private AtomicLong _EasOverloadRejectedSipResponses = new AtomicLong();
    private AtomicLong _EasOverloadRejectedHttpResponses = new AtomicLong();

    private OverloadManager() {
        // Empty constructor
    }

    public static OverloadManager getInstance() {
        return singleton;
    }

    void incrEasOverloadRejectedSipResponses() {
        _EasOverloadRejectedSipResponses.incrementAndGet();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "Counter EasOverloadRejectedSipResponses incremented: " +
                _EasOverloadRejectedSipResponses.toString());
        }
    }

    void incrEasOverloadRejectedHttpResponses() {
        _EasOverloadRejectedHttpResponses.incrementAndGet();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "Counter _EasOverloadRejectedHttpResponses incremented: " +
                _EasOverloadRejectedHttpResponses.toString());
        }
    }

    public long getEasOverloadRejectedSipResponses() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "PM counter _EasOverloadRejectedSipResponses: " +
                _EasOverloadRejectedSipResponses.toString());
        }

        return _EasOverloadRejectedSipResponses.longValue();
    }

    public long getEasOverloadRejectedHttpResponses() {
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE,
                "PM counter _EasOverloadRejectedHttpResponses: " +
                _EasOverloadRejectedHttpResponses.toString());
        }

        return _EasOverloadRejectedHttpResponses.longValue();
    }
}
