/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.SipServletMessageImpl;

import com.sun.grizzly.Pipeline;
import com.sun.grizzly.PipelineFullException;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 *
 * @author epetstr
 * This class is a thin encapsulation of the implementing class ScheduledExecutorService.
 * The main reason for encapsulating ScheduledExecutorService is to improve the exceptionghandling.
 * Now it is possible to "trap" exceptions that occurs when a task is executed in another thread
 * and log the exception.
 */
public class SipContainerThreadPool {
    private static SipContainerThreadPool _singeltonInstance = new SipContainerThreadPool();
    private Pipeline grizzlyThreadPool;
    private ScheduledThreadPoolExecutor myThreadPool = null;
    private Logger _log = (Logger) Logger.getLogger("SipContainer");

    public static SipContainerThreadPool getInstance() {
        return _singeltonInstance;
    }

    public boolean isShutdown() {
        if (myThreadPool == null) {
            return true;
        }

        return myThreadPool.isShutdown();
    }

    public void shutdown() {
        myThreadPool.shutdown();
    }

    public void initialize(int threadPoolSize) {
        myThreadPool = new ScheduledThreadPoolExecutor(threadPoolSize,
                new ThreadPoolExecutor.CallerRunsPolicy());
        myThreadPool.prestartAllCoreThreads();

        //TODO check if the queue should be set.
    }

    public void initialize(Pipeline threadpool) {
        grizzlyThreadPool = threadpool;
        //TODO Prestart threads for timers, redesign for Grizzly!!!
        initialize(grizzlyThreadPool.getMaxThreads());
    }

    /**
     * Executes the Runnable in a thread pool of worker threads
     */
    public void execute(Runnable r) {
        if (grizzlyThreadPool != null) {
            try {
                grizzlyThreadPool.execute(new MyRunnable(r));
            } catch (PipelineFullException e) {
                //_log.error("error while executing task:", e);
                throw new RuntimeException(e);
            }
        } else {
            myThreadPool.execute(new MyRunnable(r));
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay,
        TimeUnit unit) {
        return myThreadPool.schedule((Runnable) new MyRunnable(command), delay,
            unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command,
        long initialDelay, long period, TimeUnit unit) {
        return myThreadPool.scheduleAtFixedRate(new MyRunnable(command),
            initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command,
        long initialDelay, long delay, TimeUnit unit) {
        return myThreadPool.scheduleWithFixedDelay(new MyRunnable(command),
            initialDelay, delay, unit);
    }

    public void purge() {
        myThreadPool.purge();
    }

    public Integer getThreadPoolSize() {
        if (grizzlyThreadPool != null) {
            return new Integer(grizzlyThreadPool.getCurrentThreadCount());
        }

        return new Integer(myThreadPool.getPoolSize());
    }

    private class MyRunnable implements Callable, Runnable {
        private Runnable myRunnable;

        MyRunnable(Runnable r) {
            myRunnable = r;
        }

        public Object call() throws Exception {
            try {
                myRunnable.run();
                SipServletMessageImpl.removeThreadLocalData();
            } catch (Throwable t) {
                _log.log(Level.SEVERE, "error while executing task:", t);
                throw new RuntimeException(t);
            }

            return null;
        }

        public void run() {
            try {
                myRunnable.run();
                SipServletMessageImpl.removeThreadLocalData();
            } catch (Throwable t) {
                _log.log(Level.SEVERE, "error while executing task:", t);
                throw new RuntimeException(t);
            }
        }
    }
}
