/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;


/**
 *  Implementation  of <code>com.ericsson.ssa.container.SipParserErrorHandler</code> that
 *  writes a terminating response on <code>handleError</code>.
 *
 * @author elnsbur,qmaghes
 * @since Apr 11, 2006
 *
 */
public class SipParserErrorHandlerImpl extends SipParserErrorHandler {
    //Made this explicit for LinkBase now. but could be abstracted to Dispatcher.
    public SipParserErrorHandlerImpl(LinkBase base) {
        super(base);
    }

    public @Override
    void handleError(SipServletRequestImpl req, int code, String errorStr) {
        if (getErrorResponseEnabled()) {
            req.pushTransactionDispatcher(getMyDispatcher());

            SipServletResponseImpl resp = req.createResponseImpl(code, errorStr);

            // Add to tag if there is a to header and there is not yet a to tag 
            if ((resp.getHeader(Header.TO) != null) && (resp.getTo() != null) &&
                    (resp.getTo().getParameter(AddressImpl.TAG_PARAM) == null)) {
                resp.createTag(Header.TO);
            }

            try {
                TargetResolver tr = TargetResolver.getInstance();
                TargetTuple tt = tr.resolveResponse(resp);
                resp.setRemote(tt);
            } catch (Exception e) {
                e.printStackTrace();
                // Fallback if resolve failed, possibly because of Via missing or not parsable.
                resp.setRemote(req.getRemote());
            }

            resp.popDispatcher().dispatch(resp);
        }
    }
}
